'' Configuration Object for Min80 CPM system
'' Version 1.0
'' www.shaels.net

con
  c_MaxLineBytes  =    128
  c_MaxParamNameLen  =  16
  c_MaxParamValueLen =  16
  
  
var
  long KeyTableFixed
  long BufferAdr                ' Address of text buffer to scan for next text line
  {
  long  v_Disk0
  long  v_Disk1
  long  v_Disk2
  long  v_Disk3
  long  v_Com1
  long  v_Com2
  long  v_Com3
  long  v_Freq
  }
  byte  LineBuff[c_MaxLineBytes]
  byte  ParamName[c_MaxParamNameLen]
  byte  ParamValue[c_MaxParamValueLen]

pub GetLineAdr: aAdr
  aAdr:= @LineBuff
  
pub GetParamNameAdr: aAdr
  aAdr:= @ParamName
  
pub GetParamValueAdr: aAdr
  aAdr:= @ParamValue

pub Init(aBufferAdr)
  ' Initialize parser source buffer.
  ' Souce buffer must be null terminated ASCI text
  BufferAdr:= aBufferAdr
  if (KeyTableFixed == 0)
    InitParmKeys
    
pri InitParmKeys | KeyAdr, Offset, StrAdr
  ' Initialize key name table address
  KeyTableFixed:= True
  KeyAdr:= @KeyTable
  StrAdr:= word[KeyAdr]
  Offset:= @P_FirstKey - StrAdr
  if Offset
    repeat until (StrAdr == 0)
      StrAdr += Offset
      word[KeyAdr]:= StrAdr
      KeyAdr += 4 
      StrAdr:= word[KeyAdr]
    
pri FindLineBegin(BuffAdr): BeginLineAdr | LastChar
  ' Find the stat of the current line in the buffer
  ' skip all control characters and white space
  ' until we find a valid char
  '
  LastChar:= byte[BuffAdr]
  repeat until(LastChar > 32) or (LastChar == 0)
    BuffAdr++
    LastChar:= byte[BuffAdr]
  BeginLineAdr:= BuffAdr

pri FindLineEnd(BuffAdr): EndLineAdr | LastChar
  ' Find the end of the current line in the buffer
  '
  LastChar:= byte[BuffAdr]
  repeat until(LastChar == 13) or (LastChar == 0)
    BuffAdr++
    LastChar:= byte[BuffAdr]
  EndLineAdr:= BuffAdr

pri SplitParam | CharAdr, LastChar, Idx
  ' Split the line into name and value buffers
  bytefill(@ParamName, 0, c_MaxParamNameLen)
  bytefill(@ParamValue, 0, c_MaxParamValueLen)
  CharAdr:= @LineBuff
  LastChar:= byte[CharAdr++]
  Idx:= 0
  repeat until (LastChar == "=") or (LastChar == 0) or (Idx => c_MaxParamNameLen) 
    ParamName[Idx++]:= LastChar
    LastChar:= byte[CharAdr++]
  ' We have a name see if we have a value string
  if (LastChar <> 0)
    Idx:= 0
    LastChar:= byte[CharAdr++]
    repeat until (LastChar == 0) or (Idx => c_MaxParamValueLen) 
      ParamValue[Idx++]:= LastChar
      LastChar:= byte[CharAdr++]
    
pri StrMatch(St1Adr, St2Adr): Ok | C1, C2
  ' Compare to nul terminated string to see if they are equal
  C1:= byte[St1Adr++]    
  C2:= byte[St2Adr++]
  repeat until (C1 <> C2) or (C1 == 0) or (C2 == 0)    
    C1:= byte[St1Adr++]    
    C2:= byte[St2Adr++]
  Ok:= (C1 == C2)  

pri GetParamIdx: KeyIdx | Idx, KeyAdr, StrAdr
  ' see if param name matches any key name
  KeyIdx:= 0
  KeyAdr:= @KeyTable
  StrAdr:= word[KeyAdr]
  repeat until (StrAdr == 0) 
    if StrMatch(@ParamName, StrAdr)
      KeyAdr += 2
      KeyIdx:= word[KeyAdr]
      Return
    KeyAdr += 4
    StrAdr:= word[KeyAdr]
          
pri ReadNextLine(BuffAdr): NextBuffAdr | LineBytes, Idx, StartIdx
  ' Copy the next line from the buffer to the line buffer
  '
  longfill(@LineBuff, 0, constant(c_MaxLineBytes >> 2))
  StartIdx:= FindLineBegin(BuffAdr)
  NextBuffAdr:= FindLineEnd(StartIdx)
  LineBytes:= NextBuffAdr - StartIdx
  if (LineBytes > 0)
    ' copy the line to the line buffer
    if (LineBytes => c_MaxLineBytes)
      LineBytes:= constant(c_MaxLineBytes - 1)
    bytemove(@LineBuff, StartIdx, LineBytes)
    if (byte[NextBuffAdr] <> 0)
      NextBuffAdr:= NextBuffAdr + 1

pub ReadNext: KeyIdx | NextDataAdr
  ' Read the next entry from config and return its key ident.
  ' If result is = 0 all config values read.
  KeyIdx:= 0
  repeat until (KeyIdx <> 0)
    NextDataAdr:= ReadNextLine(BufferAdr)
    BufferAdr:= NextDataAdr
    if (LineBuff[0] <> ";") and (LineBuff[0] <> 0)
      SplitParam
      KeyIdx:= GetParamIdx
    elseif (LineBuff[0] == 0)
      Return
      
pub CalcParamValue: aValue | LastChar, Idx
  ' Convert the param value string to a number
  aValue:= 0
  Idx:= 0
  LastChar:= ParamValue[Idx++]
  repeat until (LastChar < "0") or (LastChar > "9")
    LastChar -= "0"
    aValue:= (aValue * 10) + LastChar
    LastChar:= ParamValue[Idx++]      
    
dat
  P_FirstKey
  P_DISK0     byte      "DISK0",0
  P_DISK1     byte      "DISK1",0
  P_DISK2     byte      "DISK2",0
  P_DISK3     byte      "DISK3",0
  P_COM1      byte      "COM1",0
  P_COM2      byte      "COM2",0
  P_COM3      byte      "COM3",0
  P_FREQ      byte      "FREQ",0
  P_IOBYTE    byte      "IOBYTE",0

  KeyTable    word      @P_DISK0, 100
              word      @P_DISK1, 101
              word      @P_DISK2, 102
              word      @P_DISK3, 103
              word      @P_COM1,  200
              word      @P_COM2,  201
              word      @P_COM3,  202
              word      @P_FREQ,  300
              word      @P_IOBYTE, 400
              word      0, 0
    