;	Emulator Drivers for CP/M 2.2
;	(four 1 Meg drives with 2048 allocation size)
;
;	Version 1.0 March 06, 2005
;
vers	equ	22	;version 2.2
;
;	Copyright (c) 1980
;	Digital Research
;	Box 579, Pacific Grove
;	California, 93950
;
;
	org	0FA00h
true	equ	0ffffh	;value of "true"
false	equ	not true	;"false"
test	equ	false	;true if test bios
;
	if	test
bias	equ	03400h	;base of CCP in test system
	endif
	if	not test
bias	equ	0000h	;generate relocatable cp/m system
	endif
;
patch	equ	1600h
;
;	org	patch
cpmb	equ	$-patch	;base of cpm console processor
bdos	equ	806h+cpmb	;basic dos (resident portion)
cpml	equ	$-cpmb	;length (in bytes) of cpm system
nsects	equ	cpml/128	;number of sectors to load
offset	equ	2	;number of disk tracks used by cp/m
cdisk	equ	0004h	;address of last logged disk on warm start
buff	equ	0080h	;default buffer address
retry	equ	01	;max retries on disk i/o before error
cr	equ	0Dh	;ascii charage return
lf	equ	0Ah	;ascii line feed
iobyte	equ	03h	;iobyte address in low memory
;
;	perform following functions
;	boot	cold start
;	wboot	warm start (save i/o byte)
;	(boot and wboot are the same for mds)
;	const	console status
;		reg-a = 00 if no character ready
;		reg-a = ff if character ready
;	conin	console character in (result in reg-a)
;	conout	console character out (char in reg-c)
;	list	list out (char in reg-c)
;	punch	punch out (char in reg-c)
;	reader	paper tape reader in (result to reg-a)
;	home	move to track 00
;
;	(the following calls are used to perform subsequent reads and writes)
;	seldsk	select disk given by reg-c (0,1,2...)
;	settrk	set track address (0,...76) for subsequent read/write
;	setsec	set sector address (1,...,26) for subsequent read/write
;	setdma	set subsequent dma address (initially 80h)
;
;	(read and write assume previous calls to set up the io parameters)
;	read	read track/sector to preset dma address
;	write	write track/sector from preset dma address
;
;	jump vector for indiviual routines
	jmp	boot
wboote:	jmp	wboot
	jmp	const
	jmp	conin
	jmp	conout
	jmp	list
	jmp	punch
	jmp	reader
	jmp	home
	jmp	seldsk
	jmp	settrk
	jmp	setsec
	jmp	setdma
	jmp	read
	jmp	write
	jmp	listst	;list status
	jmp	sectran
;
;	we have 4 1Meg drives with;
;	   1  first sector number on track
;	  32  standard sectors/track
;	   0  sector skew
;	2048  disk allocation block size
;	 512  number of allocation blocks on disk
;	 256  number of directory entries
;	 256  number of directory entries to checksum
;       offset  number of disk tracks used by cp/m
;
	maclib	diskdef	;load the disk definition library
	disks	4	;four disks
	diskdef	0,1,32,0,2048,512,255,255,offset
	diskdef	1,0
	diskdef	2,0
	diskdef	3,0
;	endef occurs at end of assembly
;
;	end of controller - independent code, the remaining subroutines
;	are tailored to the particular operating environment, and must
;	be altered for any system which differs from the intel mds.
;
;
;	Disk Drive Controller Registers
;
DCBASE	EQU 10h		;base address of disk controller
;
DC1CMD	EQU DCBASE	;O) command register, 
;		  	 0-reset, 1-home, 2-read, 3-write
DC1STA	EQU DCBASE	;I) status register, 
;		    	0-OK, 1-seek failed, 2-read failed, 
;		    	4-write failed, 8-bad disk
DC1DSK	EQU DCBASE+1	;(I/O) disk select in two ls bits (0..3)
DC1SCL	EQU DCBASE+2	;(I/O) sector value LSB
DC1SCH	EQU DCBASE+3	;(I/O) sector value MSB
DC1TRL	EQU DCBASE+4	;(I/O) track value LSB
DC1TRH	EQU DCBASE+5	;(I/O) track value MSB
DC1DAT	EQU DCBASE+6	;(I/O) 8 bit sector buffer data
DC1ADR	EQU DCBASE+7	;(I/O) 8 bit sector buffer address
;
;	Disk Controler commands
DCMRST	EQU 0	; reset disk controller
DCMHOM	EQU 1	; seek to track 0
DCMRD	EQU 2	; read sector from disk
DCMWR	EQU 3	; write disk sector
;
;
;	Serial IO Control Registers
;
;	Status bit masks used by all serial devices
;
MTXRDY	EQU 00000100b ;I/O device can be written to without blocking
MRXRDY	EQU 00000010b ;I/O device can be read from without blocking
MSDRDY	EQU 00000001b ;I/O deice is attached and ready

;	Emulator COM Port 1, ANSI terminal
CP1STA	EQU 1h	;status port to test if read/write will block
CP1DAT	EQU 0h	;I/O data is transfered through this port
;
;	Emulator COM Port 2, RS232 4 wire
CP2STA	EQU 3h	;status port to test if read/write will block
CP2DAT	EQU 2h	;I/O data is transfered through this port
;
;	Emulator COM Port 3, CMOS 2 wire, direct connect to prop chip
CP3STA	EQU 5h	;status port to test if read/write will block
CP3DAT	EQU 4h	;I/O data is transfered through this port
;
;
;	Emulator COM Port Setup Registers
;	These ports allow a CPM program to set the RS232 params
;	for the to com ports assigned to the emulator.
;
;	Bits 0..3 control the baud rate;
;		 0:    300
;		 1:    600
;		 2:   1200
;		 3:   2400
;		 4:   3600
;		 5:   4800
;		 6:   7200
;		 7:   9600
;		 8:  14400
;		 9:  19200
;		10:  28800
;		11:  38400
;		12:  57600
;		13:  76800
;		14: 115200
;		15: 128000
;
;	Bits 4..5 control the data format
;		0: 7 bits no parity
;		1: 7 bits even parity
;		2: 7 bits odd parity
;		3: 8 bits no parity
;
;	Bit 6 controls number of stop bits
;		Low: 1 stop bit
;		High: 2 stop bits
;
;	Bit 7 controls hardware flow control
;		Low: hardware flow control off
;		High: use hardware flow control lines
;
CP1CFG	EQU 30h		; uart 0 config register i/o port
CP2CFG	EQU 31h		; uart 1 config register i/o port
IOBDAT	EQU 48h		; default IOBYTE read register i/o port
;
;
CPMSPT	EQU 32	;we have 32 sectors per track on boot disk
;
	;signon message: xxk cp/m vers y.y
signon:	db	cr,lf,lf
	if	test
	db	'32'	;32k example bios
	endif
	if	not test
	db	'64'	;memory size filled by relocator
	endif
	db	'k CP/M vers '
	db	vers/10+'0','.',vers mod 10+'0'
	db	cr,lf,0
;
	;print signon message and go to ccp
boot:	di			;disable interrupts
	;the emulator wants us to reset the disk controller on any
	;restart so that it knows that no disks are in use
	mvi	a, DCMRST	;load command to reset disk controller
	out	DC1CMD		;write command to disk controller
	in	IOBDAT		;read default IOBYTE from port 48h
	sta 	IOBYTE		;save to IOBYTE
	lxi	sp, buff+80h
	lxi	h, signon
	call	prmsg		;print message
	xra	a		;clear accumulator
	sta	cdisk		;set initially to disk a
	; Pre load fat file COM image in to TPA, if required
	call	FILTPA
	; CPM is loaded in to ram, start cpm
	jmp	gocpm		;go to cp/m
;
;
	;CPM image on track 0, sector 2 
	;read cp/m from disk - assuming there is no 
	;128 byte cold start sector on track 0
;
wboot:	lxi	sp,buff+80h
	lxi	h,signon
	call	prmsg		;print message
	;the emulator wants us to reset the disk controller on any
	;restart so that it knows that no disks are in use
	mvi	a,DCMRST	;load command to reset disk controller
	out	DC1CMD		;write command to disk controller
	;see if the controller has such a disk
	lda	cdisk		;read the last selected BDOS disk
	ani	0fh		;transfer disk id to controller
	cpi	4		;we have a max of 4 drives
	jnc	wboot2		;drive id to big
	;see if selected disk is in the drive
	out	DC1DSK		;write disk id (0..3) to controller
	;see if disk will home, if not select A drive
	mvi	a,DCMHOM	;we want to send a read command
	out	DC1CMD		;send the command to disk controller
	in	DC1STA		;read status from last read command
	ora	a		;Reg A = 0 if no controller error
	jz	wboot1		;no error so just boot
	;bad disk reset to drive A user 0
wboot2:	mvi	a,0		;select drive A user 0
	sta	cdisk		;let BDOS know which drive we want
	;we have a valid drive or no disks at all
wboot1:	mvi	b,nsects
	mvi	c,retry	;max retries
	push	b
wboot0:	;enter here on error retries
	mvi 	c,0	;boot from selected drive
	call	seldsk
	lxi	b,cpmb	;set dma address to start of disk system
	call	setdma
	lxi	b,0	;start with track 0
	call	settrk	
	lxi	b,2	;start reading sector 2
	call	setsec
;
;	read sectors, count nsects to zero
	pop	b	;10-error count
rdsec:	;read next sector
	push	b	;save sector count
	call	read	;assumes disk, sector, track, and dma are all set
	ora	a	;set flags for read result
	jnz	booterr	;retry if errors occur
	lhld	iod	;increment dma address
	lxi	d,128	;sector size
	dad	d	;incremented dma address in hl
	mov	b,h
	mov	c,l	;ready for call to set dma
	call	setdma
	lda	ios	;sector number just read
	cpi	CPMSPT-1 ;read last sector?
	jc	rd1
;	must be sector CPMSPT, zero and go to next track
	lda	iotrk	;get track to register a
	inr	a
	mov	c,a	;ready for call
	mvi	b,0	;track high byte always 0 for a boot
	call	settrk
	mvi	a,0FFh	;clear sector number
rd1:	inr	a	;to next sector
	mov	c,a	;ready for call
	mvi	b,0	;sector high byte always 0 for a boot
	call	setsec
	pop	b	;recall sector count
	dcr	b	;done?
	jnz	rdsec
	lda	cdisk
	ani	0Fh
	mov 	c,a	;restore selected drive
	call	seldsk
;
;	done with the load, reset default buffer address
gocpm:	;(enter here from cold start boot)
;	reset the disk controller
;	set default buffer address to 80h
	lxi	b,buff
	call	setdma
;
;	reset monitor entry points
	mvi	a,jmp
	sta	0
	lxi	h,wboote
	shld	1	;jmp wboot at location 00
	sta	5
	lxi	h,bdos
	shld	6	;jmp bdos at location 5
;	leave iobyte set
;	previously selected disk was a, send parameter to cpm
	lda	cdisk	;last logged disk number
	mov	c,a	;send to ccp to log it in
	jmp	cpmb
;
;	error condition occurred, print message and retry
booterr:
	pop	b	;recall counts
	dcr	c
	jz	booter0
;	try again
	push	b
	jmp	wboot0
;
booter0:
;	otherwise too many retries
	lxi	h,bootmsg
	call	prmsg
	halt		;wait for a hardware rest
;
bootmsg:
	db	'boot failed!',0
;
;
const:	;console status to reg-a
	lda	IOBYTE	;CON is bits b1,b0
	ani	03h	;mask off bits for CON
	jz	CP1IS	;CON = COM1 (TTY)
	dcr	a
	jz	CP2IS	;CON = COM2 (CRT)
	dcr	a
	jz	rdrst	;CON = BAT whis is RDR
	jmp	CP3IS	;CON = COM1 (UC1)
;
conin:	;console character to reg-a
	lda	IOBYTE	;CON is bits b1,b0
	ani	03h	;mask off bits for CON
	jz	CP1I	;CON = COM1 (TTY)
	dcr	a
	jz	CP2I	;CON = CRT (CRT)
	dcr	a
	jz	reader	;CON = BAT in is RDR
	jmp	CP3I	;CON = COM3 (UC1)
;
conout:	;console character from c to console out
	lda	IOBYTE	;CON is bits b1,b0
	ani	03h	;mask off bits for CON
	jz	CP1O	;CON = COM1 (TTY)
	dcr	a
	jz	CP2O	;CON = COM2 (CRT)
	dcr	a
	jz	list	;CON = BAT uses LST
	jmp	CP3O	;CON = COM3 (UC1)
;
list:	;list device out character in reg C
	lda	IOBYTE	;LST is bits b7,b6
	rlc
	rlc		
	ani	03h	;mask off bits for LST
	jz	CP1O	;LST = COM1 (TTY)
	dcr	a
	jz	CP2O	;LST = COM2 (CRT)
	dcr	a
	jz	CP3O	;LST = COM3 (LPT which is printer)
	jmp	NULO	;LST = UL1 (NUL device)
;
listst:
	;return list status in reg A 00-not ready, FF-ready
	lda	IOBYTE	;LST is bits b7,b6
	rlc
	rlc		
	ani	03h	;mask off bits for LST
	jz	CP1OS	;LST = TTY
	dcr	a
	jz	CP2OS	;LST = CRT
	dcr	a
	jz	CP3OS	;LST = LPT which is printer
	jmp	NULOS	;LST = UL1 
;
punch:	;punch device out
	lda	IOBYTE	;PUN is bits b5,b4
	rrc
	rrc
	rrc
	rrc
	ani	03h	;mask off shifted bits for PUN
	jz	CP1O	;PUN = TTY
	dcr	a
	jz	CP2O	;PUN = PTR which is com port 2
	dcr	a
	jz	CP3O	;PUN = UP1 which is system write stream
	jmp	NULO	;PUN = UP2 which is a NULL device
;
rdrst:	;used when CON = BAT
	lda	IOBYTE	;RDR is bits b3,b2
	rrc
	rrc
	ani	03h	;mask off shifted bits for RDR
	jz	CP1IS	;RDR = TTY
	dcr	a
	jz	CP2IS	;RDR = PTR which is com port 2
	dcr	a
	jz	CP3IS	;RDR = UR1 which is system read stream
	jmp	NULIS	;RDR = UR2 which is a NULL device
;
reader:	;reader character in to reg-a
	lda	IOBYTE	;RDR is bits b3,b2
	rrc
	rrc
	ani	03h	;mask off shifted bits for RDR
	jz	CP1I	;RDR = TTY
	dcr	a
	jz	CP2I	;RDR = PTR which is com port 2
	dcr	a
	jz	CP3I	;RDR = UR1 which is system read stream
	jmp	NULI	;RDR = UR2 which is a NULL device
;
home:	;move to home position
;	treat as track 00 seek
	lxi	b,0
	jmp	settrk
;
seldsk:	;select disk given by register c
	lxi	h,0000h	;return 0000 if error
	mov	a,c
	cpi	ndisks	;too large?
	rnc		;leave HL = 0000
;
	;transfer disk id to controller and home
	out	DC1DSK	 ;write disk id (0..3) to controller
	mvi	a,DCMHOM ;we want to send a home command
	out	DC1CMD	 ;send the command to disk controller
	in	DC1STA	 ;read status from last read command
	ora	a	 ;Reg A = 0 if no controller error
	rnz		 ;if we have error in reg-a return HL = 0
	mov	a,c	 ;get back the disk number

;
	sta	iodsk	;save drive number for next disk i/o
	rlc		;mult by 16 (size of DPH)
	rlc
	rlc
	rlc
	ani	0F0h	 ;mask off low nibble in case we shifted in a high carry bit
	mov	l,a      ;load HL with drive number 0..3 mutiplied by 16 reg H is already 0
	lxi	d,DPBASE ;return address of DPH for disk 0 (base of all DPHs)
	dad	d 
	ret
;
;
settrk:	;set track address given by reg bc
	mov	l,c
	mov	h,b
	shld	iotrk
	xra	a	; clear accumulator
	ret
;
;
setsec:	;set sector number given by reg bc
	mov	l,c
	mov	h,b
	shld	ios
	xra	a	; clear accumulator
	ret
;
;
setdma:	;set dma address given by reg bc
	mov	l,c
	mov	h,b
	shld	iod
	xra	a	; clear accumulator
	ret
;
;
sectran:
	;translate sector bc using table at de and return in HL
	;we do not use translation so just move BC to HL
	mov	l,c
	mov	h,b
	ret
;
;
setdsk:	;copy disk/track/sector/dma address to controller
	;transfer disk id to controller
	lda	iodsk	;get selected disk
	out	DC1DSK	;write disk id (0..3) to controller
	;transfer sector number to controller
	lhld	ios	;get selected sector (cpm uses 1..xxx)
	mov	a,l	;get sector low byte
	out	DC1SCL	;write sector low byte to controller
	mov	a,h	;get sector high byte
	out	DC1SCH	;write sector high byte to controller
	;transfer track number to controller
	lhld	iotrk	;get selected track (cpm uses 0..xxx)
	mov	a,l	;get track low byte
	out	DC1TRL	;write track low byte to controller
	mov	a,h	;get track high byte
	out	DC1TRH	;write track high byte to controller
	ret
;
;
read:	;read next disk record (assuming disk/trk/sec/dma set)
	;first copy disk/track/sector/dma address to controller
	call	setdsk
	mvi	a,DCMRD	; we want to send a read command
	out	DC1CMD	; send the command to disk controller
	in	DC1STA	; read status from last read command
        ; if a <> 0 we failed read so just return
	ora	a
	rnz
        ; no error so copy data from disk data io port
	push	b	; save bc register
	push	h	; save hl register
	lhld	iod	; get selected dma address into hl
	mvi	b, 128	; sector has 128 bytes
	; set the disk buffer address to zero (A=0)
	out	DC1ADR
	; now read data from disk io data port into DMA location
read1:	in	DC1DAT
	mov	m, a
	inx	h	; point to next memory location
	dcr	b
	jnz	read1
	; Done with copy now clean up stack and return
	pop	h
	pop	b
        xra	a	; clear accumulator
	ret		; Reg A = 0, no controller error
			
;
;
write:	;write next disk record (assuming disk/trk/sec/dma set)
	;first copy disk/track/sector/dma address to controller
	call	setdsk
        ; copy data to disk data io port
	push	b	; save bc register
	push	h	; save hl register
	lhld	iod	; get selected dma address into hl
	mvi	b, 128	; sector has 128 bytes
	; set the disk buffer address to zero (A=0)
	xra	a	
	out	DC1ADR
	; now write data to disk io data port from DMA memory location
write1:	mov	a, m
	out	DC1DAT
	inx	h	; point to next memory location
	dcr	b
	jnz	write1
	; Done with copy now clean up stack
	pop	h
	pop	b
	; data copied to disk controller data port, write sector to disk
	mvi	a,DCMWR	;we want to send a write command
	out	DC1CMD	;send the command to disk controller
	in	DC1STA	;read status from last write command
	ret		;Reg A = 0 if no controller error
			;may have error set in reg-a
;
;
;	utility subroutines
prmsg:	;print message at h,l to 0
	mov	a,m
	ora	a	;zero?
	rz
;	more to print
	push	h
	mov	c,a
	call	conout
	pop	h
	inx	h
	jmp	prmsg
;
;
MDEVIO	MACRO DEVNAM,RSTAT,RDATA,DOESI,DOESO
;		
	if (DOESI NE 0)
DEVNAM&IS:	in  &RSTAT	;check if device status input ready
		ani MRXRDY	;checking a single bit so is 0 not ready
		rz		;reg A = 0 if not ready and A <> 0 means ready
		mvi a,0FFh	;indicate we are ready
		ret
	ENDIF
;
	if (DOESO NE 0)
DEVNAM&OS:	in  &RSTAT	;check if device status ouput ready
		ani MTXRDY	;checking a single bit so if 0 not ready
		rz		;reg A = 0 if not ready and A <> 0 means ready
		mvi a,0FFh	;indicate we are ready
		ret
	ENDIF
;
	if (DOESI NE 0)
DEVNAM&I:	in  &RSTAT	;read from device into reg A
		ani MRXRDY	;checking a single bit so if 0 not ready
		jz  DEVNAM&I	;not ready to read so try again
		in  &RDATA	;read the data byte from the device
		ret
	ENDIF
;
	if (DOESO NE 0)
DEVNAM&O:	in  &RSTAT	;write value in reg C to device
		ani MTXRDY	;checking a single bit so if 0 not ready
		jz  DEVNAM&O	;not ready to write so try again
		mov a,c		;move character into reg A
		out &RDATA	;write the data byte to the device
		ret
	ENDIF
	ENDM
;
;
;	COM1 PORT DEVICE ROUTINES
;
	MDEVIO CP1,CP1STA,CP1DAT,1,1
;
;
;	COM2 PORT DEVICE ROUTINES
;
	MDEVIO CP2,CP2STA,CP2DAT,1,1
;
;
;	COM PORT 3 DEVICE ROUTINES
;
	MDEVIO CP3,CP3STA,CP3DAT,1,1
;
;
;	COM PORT 3 DEVICE ROUTINES
;
;	MDEVIO CP2,CP2STA,CP2DAT,1,1
;
;
;	PRINTER DEVICE ROUTINES
;
;	MDEVIO PRN,PRNSTA,PRNDAT,0,1
;
;
;	STREAM WRITER DEVICE ROUTINES
;
;	MDEVIO STW,STWSTA,STWDAT,0,1
;
;
;	STEAM READER DEVICE ROUTINES
;
;	MDEVIO STR,STRSTA,STRDAT,1,0
;
;
;	NULL DEVICE ROUTINES
;
NULIS:	mvi a,0FFh	;null device can always be read
	ret
;
NULOS:	mvi a,0FFh	;null device can always be written
	ret
;
NULI:	mvi a,1Ah	;null always reads an end of file ^Z
	ret
;
NULO:	ret		;null tosses data
;
; Pre load fat file stream into TPA if stream is open
;
	; Fat controller command numbers
COPEN	EQU	05h	; open FAT stream command
CREAD	EQU	06h	; read FAT stream command
CCLOSE	EQU	07h	; close FAT stream command
	;
	; Fat file controller port numbers
FFCMD	EQU	30h		; Fat file command register
FFSTAT	EQU	30h		; Fat file staus register
FFIDX	EQU	32h		; Fat file name data index register
FFDATA	EQU	33h		; Fat file name data register
FFCNT	EQU	34h		; Fat file last read byte count in sector buffer
	;
	; Disk controller sector buffer ports
DCIDX	EQU	17h		; Disk controller sector buffer data index
DCDATA	EQU	16h		; Disk controller sector buffer data read/write
	;
        ; See if fat file stream is open, if it is load into ram
	;
	;see if stream is open
FILTPA:	IN    	FFSTAT		; read staus from open command
        ORA	A		; set CPU flags
        RNZ   			; if status <> 0 we failed read, return to caller
	;
        ; Stream is open and ready to be read
	;
        LXI	H, 100h		; HL = Program load address
        ; read next block
PRERD:	MOV	A, CREAD	; A = Fat file read command
	OUT	FFCMD		; request next sector read of fat fie stream
	; see if read was ok
	IN	FFSTAT		; A = last read status
        ORA	A		; set CPU flags
	RNZ     		; A <> 0 indicates an error, return to caller
	; we may have some bytes to read
	IN	FFCNT		; A = number of bytes read from fat file
	ORA	A		; set CPU flags
	RZ			; A = 0 indicates no error, report OK
	; more data to load
	MOV	B, A		; reg B = bytes to proccess
	PUSH	PSW		; Save byte count in register A
	; read data from disk controller and save to memory
	XRA	A		; reg A = 0
	OUT	DCIDX		; set sector buffer byte index to 0
PRERD1: IN	DCDATA		; read next data byte
	MOV	M, A		; save byte to memory
	INX	H		; point to next memory location
	DCR	B		; decrement loop counter
	JNZ	PRERD1		; if more, proccess next byte
	; copied block to ram, see if there is more
	POP	PSW		; restore byte count into reg A
	CPI	128		; see if we had less then a full 128 byte block
	JC	PRERD2		; if we did, all done loading
	; last block had 128 bytes so try again
	JMP	PRERD
	;
	; Fat file is loaded in to ram, report OK
	;
PRERD2:	XRA	A
	RET
;
;	data areas (must be in ram)
iodsk	db	0	;disk number for next io operation
iotrk:	dw	offset	;track number
ios:	dw	1	;sector number
iod:	dw	buff	;io address
;
;
;	define ram areas for bdos operation
	endef
	end
