; Z80 Boot loader for Mini80 project
; Version 1.0 December 20th, 2012
;
vers	equ	22	;version 2.2
;
;	Copyright (c) 1980
;	Digital Research
;	Box 579, Pacific Grove
;	California, 93950
;
;
	org	00000h
        JMP START    ;go to program start.
;
biosadr equ     0FA00h	; start of bios in memory
cpmadr	equ	0E400h  ; start of cpm image in memory
;
cpml	equ	0FFFFh-cpmadr+1	;length (in bytes) of cpm system
nsects	equ	cpml/128	;number of sectors to load
offset	equ	2	;number of disk tracks used by cp/m
cr	equ	0Dh	;ascii charage return
lf	equ	0Ah	;ascii line feed
CPMSPT  equ	32	;32 CPM sectors per track

;	Disk Drive Controller Registers
;
DCBASE	EQU 10h		;base address of disk controller
;
DC1CMD	EQU DCBASE	;O) command register, 
;		  	 0-reset, 1-home, 2-read, 3-write
DC1STA	EQU DCBASE	;I) status register, 
;		    	0-OK, 1-seek failed, 2-read failed, 
;		    	4-write failed, 8-bad disk
DC1DSK	EQU DCBASE+1	;(I/O) disk select in two ls bits (0..3)
DC1SCL	EQU DCBASE+2	;(I/O) sector value LSB
DC1SCH	EQU DCBASE+3	;(I/O) sector value MSB
DC1TRL	EQU DCBASE+4	;(I/O) track value LSB
DC1TRH	EQU DCBASE+5	;(I/O) track value MSB
DC1DAT	EQU DCBASE+6	;(I/O) disk controller data port
DC1ADR	EQU DCBASE+7	;(I/O) disk controller data address port
;
;	Disk Controler commands
DCMRST	EQU 0	; reset disk controller
DCMHOM	EQU 1	; seek to track 0
DCMRD	EQU 2	; read sector from disk
DCMWR	EQU 3	; write disk sector
;

;Variable storage space

MSGSTR: DB CR,LF,'Boot CPM',CR,LF,0
                
FAILSTR: DB CR,LF,'Failed to load CPM!.',CR,LF,0

;Constants

STOP   EQU 0200h         ;top of our stack.

;
; Test if OK to send byte, Z=0 if ok to send.
CANPUT:  IN  1h
         ANI 4h
         RET

; Send a byte in A register to console
PUTC:   PUSH PSW
PUTC2:  CALL CANPUT
        JZ PUTC2
        POP PSW
        OUT 0h
        RET

; Write a string to the console, HL = address of staring.
STR:    MOV A, M        ; read string char.
        ORA A           ; set cpu flags.
      m disk data io port
	push	b	; save bc register
	push	h	; save hl register
	lhld	iod	; get selected dma address into hl
	mvi	b, 128	; sector has 128 bytes
	; set the disk buffer address to zero (A=0)
	out	DC1ADR
	; now read data from disk io data port into DMA location
read1:	in	DC1DAT
	mov	m, a
	inx	h	; point to next memory location
	dcr	b
	jnz	read1
	; Done with copy now clean up stack and return
	pop	h
	pop	b
        xra	a	; clear accumulator
	ret		; Reg A = 0, no controller error
			
;
;
write:	;write next disk record (assuming disk/trk/sec/dma set)
	;first copy disk/track/sector/dma address to controller
	call	setdsk
        ; copy data to disk data io port
	push	b	; save bc register
	push	h	; save hl register
	lhld	iod	; get selected dma address into hl
	mvi	b, 128	; sector has 128 bytes
	; set the disk buffer address to zero (A=0)
	xra	a	
	out	DC1ADR
	; now write data to disk io data port from DMA memory location
write1:	mov	a, m
	out	DC1DAT
	inx	h	; point to next memory location
	dcr	b
	jnz	write1
	; Done with copy now clean up stack
	pop	h
	pop	b
	; data copied to disk controller data port, write sector to disk
	mvi	a,DCMWR	;we want to send a write command
	out	DC1CMD	;send the command to disk controller
	in	DC1STA	;read status from last write command
	ret		;Reg A = 0 if no controller error
			;may have error set in reg-a
;
;
;	utility subroutines
prmsg:	;print message at h,l to 0
	mov	a,m
	ora	a	;zero?
	rz
;	more to print
	push	h
	mov	c,a
	call	conout
	pop	h
	inx	h
	jmp	prmsg
;
;
MDEVIO	MACRO DEVNAM,RSTAT,RDATA,DOESI,DOESO
;		
	if (DOESI NE 0)
DEVNAM&IS:	in  &RSTAT	;check if device status input ready
		ani MRXRDY	;checking a single bit so is 0 not ready
		rz		;reg A = 0 if not ready and A <> 0 means ready
		mvi a,0FFh	;indicate we are ready
		ret
	ENDIF
;
	if (DOESO NE 0)
DEVNAM&OS:	in  &RSTAT	;check if device status ouput ready
		ani MTXRDY	;checking a single bit so if 0 not ready
		rz		;reg A = 0 if not ready and A <> 0 means ready
		mvi a,0FFh	;indicate we are ready
		ret
	ENDIF
;
	if (DOESI NE 0)
DEVNAM&I:	in  &RSTAT	;read from device into reg A
		ani MRXRDY	;checking a single bit so if 0 not ready
		jz  DEVNAM&I	;not ready to read so try again
		in  &RDATA	;read the data byte from the device
		ret
	ENDIF
;
	if (DOESO NE 0)
DEVNAM&O:	in  &RSTAT	;write value in reg C to device
		ani MTXRDY	;checking a single bit so if 0 not ready
		jz  DEVNAM&O	;not ready to write so try again
		mov a,c		;move character into reg A
		out &RDATA	;write the data byte to the device
		ret
	ENDIF
	ENDM
;
;
;	COM1 PORT DEVICE ROUTINES
;
	MDEVIO CP1,CP1STA,CP1DAT,1,1
;
;
;	COM2 PORT DEVICE ROUTINES
;
	MDEVIO CP2,CP2STA,CP2DAT,1,1
;
;
;	COM PORT 3 DEVICE ROUTINES
;
	MDEVIO CP3,CP3STA,CP3DAT,1,1
;
;
;	COM PORT 3 DEVICE ROUTINES
;
;	MDEVIO CP2,CP2STA,CP2DAT,1,1
;
;
;	PRINTER DEVICE ROUTINES
;
;	MDEVIO PRN,PRNSTA,PRNDAT,0,1
;
;
;	STREAM WRITER DEVICE ROUTINES
;
;	MDEVIO STW,STWSTA,STWDAT,0,1
;
;
;	STEAM READER DEVICE ROUTINES
;
;	MDEVIO STR,STRSTA,STRDAT,1,0
;
;
;	NULL DEVICE ROUTINES
;
NULIS:	mvi a,0FFh	;null device can always be read
	ret
;
NULOS:	mvi a,0FFh	;null device can always be written
	ret
;
NULI:	mvi a,1Ah	;null always reads an end of file ^Z
	ret
;
NULO:	ret		;null tosses data
;
; Pre load fat file stream into TPA if stream is open
;
	; Fat controller command numbers
COPEN	EQU	05h	; open FAT stream command
CREAD	EQU	06h	; read FAT stream command
CCLOSE	EQU	07h	; close FAT stream command
	;
	; Fat file controller port numbers
FFCMD	EQU	30h		; Fat file command register
FFSTAT	EQU	30h		; Fat file staus register
FFCNT	EQU	36h		; Fat file last read byte count in sector buffer
	;
	; Disk controller sector buffer ports
DCIDX	EQU	17h		; Disk controller sector buffer data index
DCDATA	EQU	16h		; Disk controller sector buffer data read/write
	;
        ; See if fat file stream is open, if it is load into ram
	;
	;see if stream is open
FILTPA:	IN    	FFSTAT		; read staus from open command
        ORA	A		; set CPU flags
        RNZ   			; if status <> 0 we failed read, return to caller
	;
        ; Stream is open and ready to be read
	;
        LXI	H, 100h		; HL = Program load address
        ; read next block
PRERD: