program AMount;

{$C-}

const
  NameWidth = 39;
  ScreenWidth = 78;
  NameColumns = 2;
  PageNames = 16;
  NamesStartY = 13;
  C_BootAttrib = 1;
  C_ReadOnlyAttrib = 2;
  C_DefPrompt = ' (R)ename (B)ootable (P)rotected (M)ount (Q)uit  (R,B,P,M,Q):';
  {default port addresses}
  C_DcBase = $10;


type
  TCaptionStr = string[63];
  TNameStr = string[33];
  TNames = array[0..127] of TNameStr;
  TAttribs = array[0..127] of byte;

var
  DiskCount: byte;
  DisplayPages: byte;
  NameList: TNames;
  AttribList: TAttribs;


function InC: char;

var
  Data: char;

begin
  while (not KeyPressed) do ;
  Read(KBD, Data);
  InC:= Data
end;

procedure WaitForKey(var Key: char; var Func: boolean);

var
  WasESC: boolean;
  NextKey: char;

begin
  Key:= #0;
  WasESC:= false;
  Func:= false;
  while (Key = #0) do begin
    NextKey:= InC;
    if WasESC then begin
      NextKey:= char(ord(NextKey) + 64)
    end;
    WasESC:= (NextKey = #$1B);
    if (not WasESC) Then begin
      case NextKey of
        #143:
        begin
          {we have a function key}
          Key:= InC;
          Func:= true
        end;
        #155:
        begin
          {we have an ansi esc sequence}
          repeat
            NextKey:= InC;
          until not (NextKey in ['0'..'9', ';']);
          Key:= NextKey;
          Func:= true
        end;
        else begin
          Key:= NextKey
        end
      end
    end
  end
end;

procedure OutC( Data: char);

begin
  write(CON, Data)
end;

procedure WriteEscCode(Code: char);

begin
  OutC(#$1B);
  OutC(Code)
end;

procedure WriteCSI;

begin
  OutC(#$1B);
  OutC('[')
end;

procedure WriteEsc(Code: char);

begin
  WriteCSI;
  OutC(Code)
end;

procedure WriteEsc1(Param: byte; Code: char);

begin
  WriteCSI;
  write(CON, Param);
  OutC(Code)
end;

procedure WriteEsc2(Param1, Param2: byte; Code: char);

begin
  WriteCSI;
  write(CON, Param1, ';', Param2);
  OutC(Code)
end;

procedure WriteEsc1Spi(Param: byte; Code: char);

begin
  WriteCSI;
  write(CON, '?', Param);
  OutC(Code)
end;


procedure SetBgColor(ColIdx: byte);

begin
  if (ColIdx >= 8) then begin
    ColIdx:= (ColIdx AND 7) + 60
  end
  else begin
    ColIdx:= ColIdx + 40
  end;
  WriteEsc1(ColIdx, 'm')
end;

procedure DefaultBgColor;

begin
  writeEsc1(49, 'm')
end;

procedure SetColor(ColIdx: byte);

begin
  if (ColIdx >= 8) then begin
    ColIdx:= (ColIdx AND 7) + 50
  end
  else begin
    ColIdx:= ColIdx + 30
  end;
  WriteEsc1(ColIdx, 'm')
end;

procedure DefaultColor;

begin
  writeEsc1(49, 'm')
end;

procedure SetInvert(State: boolean);

begin
  if State then begin
    lowVideo
  end
  else begin
    NormVideo
  end
end;

procedure RepeatChar(aChar: char; Num: byte);

var
  Idx: byte;

begin
  for Idx:= 1 to Num do OutC(aChar);
end;

procedure ShowCursor(State: boolean);

begin
  if State then begin
    WriteEsc1Spi(25, 'h')
  end
  else begin
    WriteEsc1Spi(25, 'l')
  end
end;

procedure DrawHR(X, Y, W: byte);

begin
  GotoXy(X, Y);
  RepeatChar('-', W);
end;

procedure DrawBox(X, Y, H, W: byte);

var
  i: byte;

begin
  GotoXy(X, Y);
  OutC('+');
  RepeatChar('-', W - 2);
  OutC('+');
  for i:= (Y + 1) to (Y + H - 2) do begin
    GotoXY(X, i);
    OutC('|');
    RepeatChar(#32, W-2);
    OutC('|')
  end;
  GotoXY(X, Y + H - 1);
  OutC('+');
  RepeatChar('-', W - 2);
  OutC('+');
end;


function ReadDskNames: byte;

var
  Name: string[63];
  i, j: byte;
  DskCnt: byte;

begin
  fillchar(NameList, sizeof(TNames), 0);
  DskCnt:= Port[$34];
  for i:= 0 to (DskCnt - 1) do begin
    port[$31]:= i; {set disk name index}
    Port[$30]:= 1; {request read name}
    Name[0]:= #0;
    for j:= 1 to 32 do begin
      Name[j]:= char(port[$33]);
      if Name[j] <> char(0) then begin
        Name[0]:= char(j)
      end
    end;
    NameList[i]:= Name;
    {read the attributes}
    AttribList[i]:= Port[$35]
  end;
  ReadDskNames:= DskCnt
end;

procedure DisplayName(Selected: boolean; X, Y, W, Idx: byte);

var
  aName: TCaptionStr;
  Pad: byte;
  Attribs: byte;
  NameWidth, NameLen: byte;

begin
  NameWidth:= W - 5;
  if (Idx < DiskCount) then begin
    Attribs:= AttribList[Idx];
    if (Attribs and 1) = 1 then begin
      aName:= '[B'
    end
    else begin
      aName:= '[_'
    end;
    if (Attribs and 2) = 2 then begin
      aName:= aName + 'R] ' + NameList[Idx]
    end
    else begin
      aName:= aName + '_] '+ NameList[Idx]
    end;
    NameLen:= length(aName);
    if (NameLen > NameWidth) then begin
      Pad:= 0;
      aName[0]:= char(NameWidth - 3);
      aName:= aName + '...';
      NameLen:= NameWidth
    end
    else begin
      Pad:= NameWidth - NameLen
    end;
    SetInvert(Selected);
    GotoXY(X, Y);
    write(Idx:4, ' ', aName);
    SetInvert(False);
    If Pad > 0 then begin
      RepeatChar(#32, Pad)
    end
  end
  else begin
    GotoXy(X, Y);
    RepeatChar(#32, W)
  end
end;

procedure DisplayMounts(X, Y: byte);

var
  i: byte;

begin
  DisplayName(False, X, Y, 37, Port[C_DcBase +  $8]);
  DisplayName(False, X, Y + 1, 37, Port[C_DcBase + $9]);
  DisplayName(False, X, Y + 2, 37, Port[C_DcBase + $A]);
  DisplayName(False, X, Y + 3, 37, Port[C_DcBase + $B]);
end;

procedure DrawNames(StartY, FirstName, SelIdx, Count: byte);

var
  Idx: byte;
  X, Y: byte;

begin
  X:= 1;
  Y:= StartY;
  Idx:= FirstName;
  while (Count > 0) do begin
    DisplayName(Idx = SelIdx, X, Y, NameWidth, Idx);
    X:= X + NameWidth;
    if (X > ScreenWidth) then begin
      X:= 1;
      Y:= Y + 1
    end;
    Idx:= Idx + 1;
    Count:= Count - 1
  end;
end;

procedure DrawPage(Page, Y, SelIdx: byte);

var
  StartIdx: byte;

begin
  StartIdx:= Page * PageNames;
  if (StartIdx < DiskCount) then begin
    DrawNames(NamesStartY, StartIdx, SelIdx, PageNames)
  end
end;

procedure DrawSelected(Y, OldSel, NewSel: byte);

var
  OldPage, PageReq: byte;
  NX, NY, PageIdx: byte;

begin
  PageReq:= NewSel div PageNames;
  OldPage:= OldSel div PageNames;
  if (PageReq = OldPage) then begin
    PageIdx:= OldSel mod PageNames;
    NX:= 1 + (PageIdx mod NameColumns) * NameWidth;
    NY:= Y + (PageIdx div NameColumns);
    DisplayName(False, NX, NY, NameWidth, OldSel);
    PageIdx:= NewSel mod PageNames;
    NX:= 1 + (PageIdx mod NameColumns) * NameWidth;
    NY:= Y + (PageIdx div NameColumns);
    DisplayName(True, NX, NY, NameWidth, NewSel);
  end
  else begin
    DrawPage(PageReq, Y, NewSel)
  end
end;

function IsMounted(DskIdx: byte; var DriveIdx: byte): boolean;

var
  Mounted: boolean;
  Idx: byte;

begin
  Mounted:= false;
  for Idx:= C_DcBase+$8 to C_DcBase+$B do begin
    if (DskIdx = Port[Idx]) then begin
      Mounted:= true;
      DriveIdx:= Idx - (C_DcBase+$8)
    end
  end;
  IsMounted:= Mounted
end;

procedure RenameDisk(X, Y, DiskIdx: byte);

var
  aName:TNameStr;
  Idx, Len, DriveIdx: byte;

begin
  GotoXy(X, Y);
  ClrEOL;
  Write('New Disk Name (blank for no change):');
  ShowCursor(True);
  LowVideo;
  write(' ');
  BufLen:= 32;
  Readln(aName);
  NormVideo;
  ShowCursor(False);
  if (aName <> '') then begin
    Len:= length(aName);
    if (Len > 32) then aName[0]:= #32;
    port[$31]:= DiskIdx; {set disk index to rename}
    Port[32]:= 0;
    for Idx:= 1 to Len do begin
      Port[$33]:= byte(aName[Idx])
    end;
    for Idx:= Len to 31 do begin
      Port[$33]:= 0
    end;
    Port[$30]:= 2;
    NameList[DiskIdx]:= aName;
    if IsMounted(DiskIdx, DriveIdx) then DisplayMounts(12, 4);
  end;
  GotoXy(X, Y);
  ClrEOL;
end;

procedure ResetDisks;

begin
  BDOS(13) {reset all cpm disks}
end;


procedure MountDisk(DriveIdx, DiskIdx: byte);

var
  CurDiskIdx, aDrive: byte;

begin
  if (DriveIdx < 4) then begin
    CurDiskIdx:= Port[C_DcBase+$8 + DriveIdx];
    if (CurDiskIdx <> DiskIdx) then begin
      if IsMounted(DiskIdx, aDrive) then begin
        {disk is in another drive, swap them}
        Port[C_DcBase + $8 + DriveIdx]:= DiskIdx;
        Port[C_DcBase + $C + DriveIdx]:= AttribList[DiskIdx];
        Port[C_DcBase + $8 + aDrive]:= CurDiskIdx;
        Port[C_DcBase + $C + aDrive]:= AttribList[CurDiskIdx];
      end
      else begin
        Port[C_DcBase + $8 + DriveIdx]:= DiskIdx;
        Port[C_DcBase + $C + DriveIdx]:= AttribList[DiskIdx];
      end;
      DisplayMounts(12, 4);
      ResetDisks;
    end
  end
end;



procedure Message( Msg: TCaptionStr);

begin
  GotoXY(2,24);
  write(Msg);
  ClrEOL
end;

procedure DefaultPrompt;
begin
  Message(C_DefPrompt)
end;

procedure ReqestDiskMount(DiskIdx: byte);

var
  LastKey: char;
  IsFunc: boolean;

begin
  Message(' Select drive to mount selected disk (A.B.C,D or Q to quit):');
  ShowCursor(True);
  LastKey:= #0;
  while (LastKey <> 'Q') do begin
    WaitForKey(LastKey, IsFunc);
    if IsFunc then begin
      LastKey:= #0
    end
    else begin
      LastKey:= UpCase(LastKey);
      case LastKey of
        'A':
          begin
            MountDisk(0, DiskIdx);
            LastKey:= 'Q'
          end;
        'B':
          begin
            MountDisk(1, DiskIdx);
            LastKey:= 'Q'
          end;
        'C':
          begin
            MountDisk(2, DiskIdx);
            LastKey:= 'Q'
          end;
        'D':
          begin
            MountDisk(3, DiskIdx);
            LastKey:= 'Q'
          end;
      end
    end
  end
end;


procedure ToogleAttrib(AttribBit, DskIdx: byte);

var
  Attribs: byte;
  DriveIdx: byte;

begin
  port[$31]:= DskIdx; {set disk index for update}
  Attribs:= AttribList[DskIdx];
  Attribs:= Attribs XOR AttribBit;
  {save new attributes}
  AttribList[DskIdx]:= Attribs;
  Port[$35]:= Attribs;
  {display changes to selected item}
  if IsMounted(DskIdx, DriveIdx) then begin
    {update disk controller attributes register}
    Port[C_DcBase + $C + DriveIdx]:= Attribs;
    DisplayMounts(12, 4)
  end
end;

procedure ShowPage(DiskIdx: byte);

Var
 PageNum, PageTotal: byte;

begin
 PageNum:= (DiskIdx div PageNames) + 1;
 PageTotal:= (DiskCount + (PageNames - 1)) div PageNames;
 GotoXY(ScreenWidth - 16, NamesStartY - 2);
 write('[ Page: ', PageNum:1, ' of ', PageTotal:1, ']')
end;


procedure InitScr;

begin
  ShowCursor(False);
  ClrScr;
  SetInvert(False);
  DrawBox(2, 2, 8, 52);
  GotoXY(4, 2);
  write('[Mounted Disks]');
  GotoXY(4,4);
  Write('Drive A: ');
  GotoXY(4,5);
  Write('Drive B: ');
  GotoXY(4,6);
  Write('Drive C: ');
  GotoXY(4,7);
  Write('Drive D: ');
  DrawHR(1, NamesStartY - 2, ScreenWidth);
  GotoXY(4,NamesStartY - 2);
  Write('[Available Disks]');
  DrawHR(1, NamesStartY + (PageNames div NameColumns) + 1, ScreenWidth);
end;

var
  X, Y: byte;
  SelIdx, OldSel: byte;
  LastKey: char;
  PageNum: byte;
  IsFunc: boolean;

begin
  writeln;
  write(' Loading disk information...');
  DiskCount:= ReadDskNames;
  InitScr;
  SelIdx:= 0;
  PageNum:= 0;
  LastKey:= #0;
  DisplayMounts(12, 4);
  DrawPage(PageNum, NamesStartY, SelIdx);
  ShowPage(SelIdx);
  DefaultPrompt;
  while (LastKey <> 'Q') do begin
    GotoXY(2 + length(C_DefPrompt), 24);
    ShowCursor(True);
    WaitForKey(LastKey, IsFunc);
    ShowCursor(False);
    if IsFunc then begin
      OldSel:= SelIdx;
      case LastKey of
        'C':
        begin
          if (SelIdx < (DiskCount - 1)) then begin
            SelIdx:= SelIdx + 1;
          end
        end;
        'D':
        begin
          if (SelIdx > 0) then begin
            SelIdx:= SelIdx - 1;
          end
        end;
        'B':
        begin
          if (SelIdx < (DiskCount - NameColumns)) then begin
            SelIdx:= SelIdx + NameColumns;
          end
        end;
        'A':
        begin
          if (SelIdx >= NameColumns) then begin
            SelIdx:= SelIdx - NameColumns;
          end
        end;
        'I':
        begin
          if (SelIdx >= PageNames) then begin
            SelIdx:= SelIdx - PageNames
          end
        end;
        'J':
        begin
          if (SelIdx < (DiskCount - PageNames)) then begin
            SelIdx:= SelIdx + PageNames
          end
        end
      end;
      if (OldSel <> SelIdx) then begin
        DrawSelected(NamesStartY, OldSel, SelIdx);
        ShowPage(SelIdx)
      end
    end
    else begin
      LastKey:= UpCase(LastKey);
      case LastKey of
        'M':
        begin
          ReqestDiskMount(SelIdx);
          DefaultPrompt
        end;
        'R':
        begin
          RenameDisk(2, 24, SelIdx);
          DrawSelected(NamesStartY, SelIdx, SelIdx);
          DefaultPrompt
        end;
        'B':
        begin
          ToogleAttrib(C_BootAttrib, SelIdx);
          DrawSelected(NamesStartY, SelIdx, SelIdx);
          DefaultPrompt
        end;
        'P':
        begin
          ToogleAttrib(C_ReadOnlyAttrib, SelIdx);
          DrawSelected(NamesStartY, SelIdx, SelIdx);
          DefaultPrompt
        end
      end
    end
  end;
  ResetDisks;
  CrtExit
end.