program FatFiles;

{$C-}
{$I-}

const
  NameWidth = 32;
  ScreenWidth = 64;
  NameColumns = 2;
  PageNames = 16;
  NamesStartY = 13;
  C_DefPrompt = ' (I)moprt (B)atch (S)elect (A)ll (N)one (Q)uit  (I,B,S,A,N,Q):';
  {default port addresses}
  C_DcBase = $10;
  DiskAllocBytes: real = 2048.0;

type
  TCaptionStr = string[63];
  TNameStr = string[16];
  TDiskNameStr = string[33];
  TNames = array[0..127] of TNameStr;
  TSizes = array[0..127] of Real;
  TAttribs = array[0..127] of boolean;
  TSectBuf = array[0..511] of byte;

var
  FileCount: byte;
  DisplayPages: byte;
  NameList: TNames;
  SizeList: TSizes;
  SelectedList: TAttribs;


function InC: char;

var
  Data: char;

begin
  while (not KeyPressed) do ;
  Read(KBD, Data);
  InC:= Data
end;

procedure WaitForKey(var Key: char; var Func: boolean);

var
  WasESC: boolean;
  NextKey: char;

begin
  Key:= #0;
  WasESC:= false;
  Func:= false;
  while (Key = #0) do begin
    NextKey:= InC;
    if WasESC then begin
      NextKey:= char(ord(NextKey) + 64)
    end;
    WasESC:= (NextKey = #$1B);
    if (not WasESC) Then begin
      case NextKey of
        #143:
        begin
          {we have a function key}
          Key:= InC;
          Func:= true
        end;
        #155:
        begin
          {we have an ansi esc sequence}
          repeat
            NextKey:= InC;
          until not (NextKey in ['0'..'9', ';']);
          Key:= NextKey;
          Func:= true
        end;
        else begin
          Key:= NextKey
        end
      end
    end
  end
end;

procedure OutC( Data: char);

begin
  write(CON, Data)
end;

procedure WriteEscCode(Code: char);

begin
  OutC(#$1B);
  OutC(Code)
end;

procedure WriteCSI;

begin
  OutC(#$1B);
  OutC('[')
end;

procedure WriteEsc(Code: char);

begin
  WriteCSI;
  OutC(Code)
end;

procedure WriteEsc1(Param: byte; Code: char);

begin
  WriteCSI;
  write(CON, Param);
  OutC(Code)
end;

procedure WriteEsc2(Param1, Param2: byte; Code: char);

begin
  WriteCSI;
  write(CON, Param1, ';', Param2);
  OutC(Code)
end;

procedure WriteEsc1Spi(Param: byte; Code: char);

begin
  WriteCSI;
  write(CON, '?', Param);
  OutC(Code)
end;


procedure SetBgColor(ColIdx: byte);

begin
  if (ColIdx >= 8) then begin
    ColIdx:= (ColIdx AND 7) + 60
  end
  else begin
    ColIdx:= ColIdx + 40
  end;
  WriteEsc1(ColIdx, 'm')
end;

procedure DefaultBgColor;

begin
  writeEsc1(49, 'm')
end;

procedure SetColor(ColIdx: byte);

begin
  if (ColIdx >= 8) then begin
    ColIdx:= (ColIdx AND 7) + 50
  end
  else begin
    ColIdx:= ColIdx + 30
  end;
  WriteEsc1(ColIdx, 'm')
end;

procedure DefaultColor;

begin
  writeEsc1(49, 'm')
end;

procedure SetInvert(State: boolean);

begin
  if State then begin
    lowVideo
  end
  else begin
    NormVideo
  end
end;

procedure RepeatChar(aChar: char; Num: byte);

var
  Idx: byte;

begin
  for Idx:= 1 to Num do OutC(aChar);
end;

procedure ShowCursor(State: boolean);

begin
  if State then begin
    WriteEsc1Spi(25, 'h')
  end
  else begin
    WriteEsc1Spi(25, 'l')
  end
end;

procedure DrawHR(X, Y, W: byte);

begin
  GotoXy(X, Y);
  RepeatChar('-', W);
end;

procedure DrawBox(X, Y, H, W: byte);

var
  i: byte;

begin
  GotoXy(X, Y);
  OutC('+');
  RepeatChar('-', W - 2);
  OutC('+');
  for i:= (Y + 1) to (Y + H - 2) do begin
    GotoXY(X, i);
    OutC('|');
    RepeatChar(#32, W-2);
    OutC('|')
  end;
  GotoXY(X, Y + H - 1);
  OutC('+');
  RepeatChar('-', W - 2);
  OutC('+');
end;

function GetFatSize: real;

var
  A, B, C, D, T: real;

begin
  A:= Port[$37];
  B:= Port[$38];
  C:= Port[$39];
  D:= Port[$3A];
  T:= 256;
  GetFatSize:= A + (B * T) + (C * T * T) + (D * T * T * T);
end;

function ReadFatNames: byte;

var
  aName: string[15];
  Res, Idx, Data: byte;
  NameCnt: byte;

begin
  fillchar(NameList, sizeof(TNames), 0);
  fillchar(SizeList, sizeof(TSizes), 0);
  NameCnt:= 0;
  port[$30]:= 3;
  Res:= Port[$30];
  while (Res = 0) do begin
    Idx:= 0;
    Data:= port[$33];
    while (Data <> 0) do begin
      Idx:= Idx + 1;
      aName[Idx]:= char(Data);
      Data:= port[$33];
    end;
    aName[0]:= char(Idx);
    NameList[NameCnt]:= aName;
    SizeList[NameCnt]:= GetFatSize;
    SelectedList[NameCnt]:= False;
    NameCnt:= NameCnt + 1;
    port[$30]:= 4;
    Res:= Port[$30];
  end;
  ReadFatNames:= NameCnt
end;

function FileDskSize(FileSize: real): real;

var
  A, B: real;

begin
  A:= FileSize;
  B:= DiskAllocBytes;
  A:= int(A /B);
  A:= A * B;
  if (A < FileSize) then begin
    A:= A + B
  end;
  FileDskSize:= A
end;

procedure CalcSelSpace(var Count: byte; var Space: real);

var
  Idx: byte;

begin
  Count:= 0;
  Space:= 0;
  for Idx:= 0 to FileCount -1 do begin
    if SelectedList[Idx] then begin
      Count:= Count + 1;
      Space:= Space + FileDskSize(SizeList[Idx])
    end
  end
end;

procedure DisplayName(Selected: boolean; X, Y, W, Idx: byte);

var
  aName: TCaptionStr;
  Pad: byte;
  SelFile: boolean;
  NameWidth, NameLen: byte;

begin
  NameWidth:= W - 15;
  if (Idx < FileCount) then begin
    SelFile:= SelectedList[Idx];
    if SelFile then begin
      aName:= '[X] '
    end
    else begin
      aName:= '[_] '
    end;
    aName:= aName + NameList[Idx];
    NameLen:= length(aName);
    if (NameLen > NameWidth) then begin
      Pad:= 0;
      aName[0]:= char(NameWidth - 3);
      aName:= aName + '...';
      NameLen:= NameWidth
    end
    else begin
      Pad:= NameWidth - NameLen
    end;
    SetInvert(Selected);
    GotoXY(X, Y);
    write(Idx:4, ' ', aName);
    If Pad > 0 then begin
      RepeatChar(#32, Pad)
    end;
    write(SizeList[Idx]:10:0);
    SetInvert(False);
  end
  else begin
    GotoXy(X, Y);
    RepeatChar(#32, W)
  end
end;

procedure GetDiskName(DiskIdx: byte; var DiskName: TDiskNameStr);

var
  Data, Idx, Len: byte;

begin
  DiskName:= '';
  port[$31]:= DiskIdx; {set disk index to get name of}
  Port[$30]:= 1; {request name be read}
  Port[$32]:= 0;
  Len:= 0;
  Data:= Port[$33];
  while (Data <> 0) and (Len < 32) do begin
    Len:= Len + 1;
    DiskName[Len]:= char(Data);
    Data:= Port[$33]
  end;
  DiskName[0]:= char(Len)
end;

procedure DisplayDiskName(X, Y, NameWidth, DiskIdx: byte);

var
  DiskName: TDiskNameStr;
  Pad: byte;

begin
  GetDiskName(DiskIdx, DiskName);
  GotoXY(X, Y);
  Write(DiskName);
  Pad:= NameWidth - Length(DiskName);
  If Pad > 0 then begin
    RepeatChar(#32, Pad)
  end
end;

procedure ReadDskParams(var BlockShift, ExtMask: byte; var Blocks: integer);

var
  ParamAdr: integer;

begin
  ParamAdr:= BdosHL(31);
  ParamAdr:= ParamAdr + 2;
  BlockShift:= mem[ParamAdr];
  ParamAdr:= ParamAdr + 2;
  ExtMask:= mem[ParamAdr];
  ParamAdr:= ParamAdr + 2;
  Blocks:= mem[ParamAdr];
  Blocks:= Blocks shl 8;
  ParamAdr:= ParamAdr - 1;
  Blocks:= Blocks or mem[ParamADr];
  Blocks:= Blocks + 1
end;


procedure CpmDiskSpace(Drive: byte; var FreeSpace: real);

var
  BlockShift, ExtMask: byte;
  Idx, Bit, Data: byte;
  Blocks, AlocSize, AllocAdr: integer;
  A: real;

begin
  BDOS(14, Drive);
  ReadDskParams(BlockShift, ExtMask, Blocks);
  AlocSize:= 128 shl Blockshift;
  A:= AlocSize;
  {now scan allocation map to see what blocks are in use}
  AllocAdr:= BdosHL(27);
  for Idx:=0 to (Blocks div 8) - 1 do begin
    Data:= mem[AllocAdr];
    AllocAdr:= AllocAdr + 1;
    for Bit:= 0 to 7 do begin
      if (Data and 128) <> 0 then begin
        Blocks:= Blocks - 1
      end;
      Data:= Data shl 1
    end
  end;
  FreeSpace:= Blocks;
  FreeSpace:= FreeSpace * A
end;


procedure DisplayMounts(X, Y: byte);

var
  Drive: byte;
  FreeSpace: real;


begin
  ShowCursor(False);
  X:= X + 1;
  for Drive:= 0 to 3 do begin
    CpmDiskSpace(Drive, FreeSpace);
    GotoXY(X, Y + Drive);
    write(FreeSpace / 1024.0:4:0, 'K ');
    DisplayDiskName(X + 7, Y + Drive, 30, Port[C_DcBase +  $8 + Drive]);
  end
end;

procedure DrawNames(StartY, FirstName, SelIdx, Count: byte);

var
  Idx: byte;
  X, Y: byte;

begin
  X:= 1;
  Y:= StartY;
  Idx:= FirstName;
  while (Count > 0) do begin
    DisplayName(Idx = SelIdx, X, Y, NameWidth, Idx);
    X:= X + NameWidth;
    if (X > ScreenWidth) then begin
      X:= 1;
      Y:= Y + 1
    end;
    Idx:= Idx + 1;
    Count:= Count - 1
  end;
end;

procedure ShowSelected(X, Y: byte);

var
  Count, Pad: byte;
  Space: real;
  St: string[ScreenWidth];
  St2: string[15];

begin
  CalcSelSpace(Count, Space);
  GotoXY(X, Y);
  St:= '[Selected: ';
  Str(Count, St2);
  St:= St + St2;
  Str(Space / 1024.0:1:0, St2);
  St:= St + ' ' + St2 + 'K bytes]';
  write(St);
  Pad:= X + length(st);
  if (Pad < ScreenWidth) then begin
    Pad:= ScreenWidth - Pad;
    RepeatChar('-', Pad)
  end
end;

procedure DrawPage(Page, Y, SelIdx: byte);

var
  StartIdx: byte;

begin
  StartIdx:= Page * PageNames;
  if (StartIdx < FileCount) then begin
    DrawNames(NamesStartY, StartIdx, SelIdx, PageNames)
  end
end;

procedure DrawSelected(Y, OldSel, NewSel: byte);

var
  OldPage, PageReq: byte;
  NX, NY, PageIdx: byte;

begin
  PageReq:= NewSel div PageNames;
  OldPage:= OldSel div PageNames;
  if (PageReq = OldPage) then begin
    PageIdx:= OldSel mod PageNames;
    NX:= 1 + (PageIdx mod NameColumns) * NameWidth;
    NY:= Y + (PageIdx div NameColumns);
    DisplayName(False, NX, NY, NameWidth, OldSel);
    PageIdx:= NewSel mod PageNames;
    NX:= 1 + (PageIdx mod NameColumns) * NameWidth;
    NY:= Y + (PageIdx div NameColumns);
    DisplayName(True, NX, NY, NameWidth, NewSel);
  end
  else begin
    DrawPage(PageReq, Y, NewSel)
  end
end;

procedure Message( Msg: TCaptionStr);

begin
  GotoXY(2,24);
  write(Msg);
  ClrEOL
end;

procedure MessageWait( Msg: TCaptionStr);

var
  LastChar, Option: char;
  IsFunc: boolean;

begin
  Message(Msg);
  write(' Press Enter:');
  ShowCursor(True);
  repeat
    WaitForKey(LastChar, IsFunc);
  until (LastChar = #13) and (not IsFunc)
end;


function Prompt( Msg: TCaptionStr): boolean;

var
  LastChar, Option: char;
  IsFunc: boolean;

begin
  GotoXY(2,24);
  write(Msg, '(Y/N)?');
  ShowCursor(True);
  ClrEOL;
  Option:= #0;
  while (Option = #0) do begin
    WaitForKey(LastChar, IsFunc);
    if (not IsFunc) then begin
      if (LastChar = 'Y')  or (LastChar = 'y') then begin
        Option:= 'Y'
      end
      else begin
        if (LastChar = 'N')  or (LastChar = 'n') then begin
          Option:= 'N'
        end
      end
    end
  end;
  Prompt:= (Option = 'Y')
end;

procedure DefaultPrompt;
begin
  Message(C_DefPrompt)
end;

function FileExists(aFileName: TNameStr): boolean;

var
  F: File;

begin
  Assign(F, aFileName);
  Reset(F);
  if (IoResult = 0) then begin
    Close(F);
    FileExists:= True
  end
  else begin
    FileExists:= False
  end
end;

function OpenFatFile( aFileName: TNameStr): boolean;

var
  Idx, NameLen: byte;

begin
  Port[$32]:= 0; {name pointer to first address}
  {Copy name to name buffer}
  NameLen:= Length(aFileName);
  for Idx:= 1 to 32 do begin
    if (Idx <= NameLen) then begin
      Port[$33]:= byte(aFileName[Idx])
    end
    else begin
      Port[$33]:= 0
    end
  end;
  {request input file stream to be opened}
  Port[$30]:= 5;
  OpenFatFile:= (Port[$30] = 0)
end;

function ReadFatFile(var Data: TSectBuf; var Count: byte): boolean;

var
  Idx: byte;

begin
  Port[$30]:= 6; {read next FAT file block into sector buffer}
  Count:= Port[$36];
  Port[$07]:= 0;
  if (Count > 0) then begin
    for Idx:= 0 to Count-1 do begin
      Data[Idx]:= Port[$0F]
    end
  end;
  ReadFatFile:= (Port[$30] = 0)
end;

procedure CloseFatFile;

begin
  Port[$30]:= 7
end;

function FileFits(DriveIdx: byte; FileSize: real): boolean;

var
  Fits: boolean;
  DiskSpace: real;

begin
  Fits:= False;
  FileSize:= FileDskSize(FileSize);
  CpmDiskSpace(DriveIdx, DiskSpace);
  FileFits:= (DiskSpace > FileSize)
end;


function ImportFile(DiskIdx, FileIdx:byte): boolean;

var
  F: File;
  aCpmName: TNameStr;
  CanCopy, Ok: boolean;
  BytesRead: byte;
  Data: TSectBuf;
  Cnt: integer;
  StInt, StCnt: real;
  A: real;
  ErrorMsg: string[ScreenWidth];

begin
  Ok:= True;
  BytesRead:= 0;
  aCpmName:= char(ord('A') + DiskIdx) + ':' + NameList[FileIdx];
  CanCopy:= not FileExists(aCpmName);
  if (not CanCopy) then begin
    CanCopy:= Prompt('Overwrite existing file "' + aCpmName + '" ')
  end;
  if CanCopy then begin
    if OpenFatFile(NameList[FileIdx]) then begin
      Assign(F, aCpmName);
      Rewrite(F);
      Ok:= (IoResult = 0);
      if Ok then begin
        Ok:= FileFits(DiskIdx, SizeList[FileIdx]);
        if OK then begin
          A:= ScreenWidth - 21;
          StInt:= SizeList[FileIdx] / A;
          StCnt:= 0;
          Message('Import "'+NameList[FileIdx]+'"');
          repeat
            OK:= ReadFatFile(Data, BytesRead);
            if OK then begin
              if (BytesRead > 0) then begin
                if (BytesRead < 128) then begin
                  fillchar(Data[BytesRead], 128 - BytesRead, 0)
                end;
                blockWrite(F, Data, 1);
                Ok:= (IoResult = 0);
                if Ok then begin
                  StCnt:= StCnt + 128.0;
                  if (StCnt >= StInt) then begin
                    StCnt:= StCnt - StInt;
                    write('.')
                  end
                end
                else begin
                  ErrorMsg:= ' Unable to write to CPM file.'
                end
              end
            end
            else begin
              ErrorMsg:= ' Unable to read from FAT file stream.'
            end
          until (BytesRead < 128) or (not Ok);
        end
        else begin
          ErrorMsg:= 'File "'+NameList[FileIdx]+' is to large to import.'
        end;
        Close(F);
        if (not Ok) then begin
          Assign(F, aCpmName);
          Erase(F);
          StInt:= IoResult
        end;
        DisplayMounts(12, 4)
      end
      else begin
        ErrorMsg:= 'Unable to create CPM file.'
      end;
      CloseFatFile
    end
    else begin
      ErrorMsg:= 'Unable to open FAT file stream.';
      Ok:= False
    end
  end;
  if (Not OK) then begin
    MessageWait(ErrorMsg)
  end;
  ImportFile:= Ok
end;

function SelImportDsk: byte;

var
  LastKey: char;
  IsFunc, Done: boolean;
  Disk: byte;

begin
  Disk:= 255; {no disk seleceted}
  Message(' Drive to import file(s) (A.B.C,D or Q to quit):');
  ShowCursor(True);
  LastKey:= #0;
  while (LastKey <> 'Q') do begin
    WaitForKey(LastKey, IsFunc);
    if IsFunc then begin
      LastKey:= #0
    end
    else begin
      LastKey:= UpCase(LastKey);
      if (LastKey in ['A'..'D']) then begin
        Disk:= ord(LastKey) - ord('A');
        LastKey:= 'Q'
      end
    end
  end;
  SelImportDsk:= Disk
end;


procedure ReqestFileImport(FileIdx: byte);

var
  Disk: byte;
  Done: boolean;

begin
  Disk:= SelImportDsk;
  if (Disk in [0..3]) then begin
    Done:= ImportFile(Disk, FileIdx)
  end
end;

procedure ImportSelected;

var
  FileIdx, DiskIdx, Count, ImpCount: byte;
  DiskSpace, SelSpace: real;
  Ok: boolean;

begin
  CalcSelSpace(Count, SelSpace);
  if (Count > 0) then begin
    DiskIdx:= SelImportDsk;
    if (DiskIdx in [0..3]) then begin
      if FileFits(DiskIdx, SelSpace) then begin
        FileIdx:= 0;
        ImpCount:= 0;
        Ok:= true;
        while Ok and (FileIdx < FileCount) do begin
          if SelectedList[FileIdx] then begin
            Ok:= ImportFile(DiskIdx, FileIdx);
            ImpCount:= ImpCount + 1;
            if (not Ok) and (Count > ImpCount) then begin
              Ok:= Prompt('Continue to import files')
            end
          end;
          FileIdx:= FileIdx + 1;
        end
      end
      else begin
        MessageWait('Selected file(s) do not fit on disk.')
      end
    end
  end
  else begin
    MessageWait('No files selected for import.')
  end

end;

procedure ToogleSelected(FileIdx: byte);


begin
  SelectedList[FileIdx]:= not SelectedList[FileIdx];
end;

procedure ClearSelected;

var
  Idx: byte;

begin
  for Idx:=0 to FileCount - 1 do begin
    SelectedList[Idx]:= false
  end
end;

procedure SelectAll;

var
  Idx: byte;

begin
  for Idx:=0 to FileCount - 1 do begin
    SelectedList[Idx]:= true
  end
end;

procedure ShowPage(DiskIdx: byte);

Var
 PageNum, PageTotal: byte;

begin
 PageNum:= (DiskIdx div PageNames) + 1;
 PageTotal:= (FileCount + (PageNames - 1)) div PageNames;
 GotoXY(ScreenWidth - 16, NamesStartY - 2);
 write('[ Page: ', PageNum:1, ' of ', PageTotal:1, ']')
end;


procedure InitScr;

begin
  ShowCursor(False);
  ClrScr;
  SetInvert(False);
  DrawBox(2, 2, 8, 52);
  GotoXY(4, 2);
  write('[Mounted Disks]');
  GotoXY(4,4);
  Write('Drive A: ');
  GotoXY(4,5);
  Write('Drive B: ');
  GotoXY(4,6);
  Write('Drive C: ');
  GotoXY(4,7);
  Write('Drive D: ');
  DrawHR(1, NamesStartY - 2, ScreenWidth);
  GotoXY(4,NamesStartY - 2);
  Write('[Available Files]');
  DrawHR(1, NamesStartY + (PageNames div NameColumns) + 1, ScreenWidth);
end;

var
  X, Y: byte;
  SelIdx, OldSel: byte;
  LastKey: char;
  PageNum: byte;
  IsFunc: boolean;

begin
  writeln;
  write(' Loading disk information...');
  FileCount:= ReadFatNames;
  InitScr;
  SelIdx:= 0;
  PageNum:= 0;
  LastKey:= #0;
  DisplayMounts(12, 4);
  DrawPage(PageNum, NamesStartY, SelIdx);
  ShowPage(SelIdx);
  DefaultPrompt;
  while (LastKey <> 'Q') do begin
    GotoXY(2 + length(C_DefPrompt), 24);
    ShowCursor(True);
    WaitForKey(LastKey, IsFunc);
    ShowCursor(False);
    if IsFunc then begin
      OldSel:= SelIdx;
      case LastKey of
        'C':
        begin
          if (SelIdx < (FileCount - 1)) then begin
            SelIdx:= SelIdx + 1;
          end
        end;
        'D':
        begin
          if (SelIdx > 0) then begin
            SelIdx:= SelIdx - 1;
          end
        end;
        'B':
        begin
          if (SelIdx < (FileCount - NameColumns)) then begin
            SelIdx:= SelIdx + NameColumns;
          end
        end;
        'A':
        begin
          if (SelIdx >= NameColumns) then begin
            SelIdx:= SelIdx - NameColumns;
          end
        end;
        'I':
        begin
          if (SelIdx >= PageNames) then begin
            SelIdx:= SelIdx - PageNames
          end
        end;
        'J':
        begin
          if (SelIdx < (FileCount - PageNames)) then begin
            SelIdx:= SelIdx + PageNames
          end
        end
      end;
      if (OldSel <> SelIdx) then begin
        DrawSelected(NamesStartY, OldSel, SelIdx);
        ShowPage(SelIdx)
      end
    end
    else begin
      LastKey:= UpCase(LastKey);
      case LastKey of
        'S', ' ':
        begin
          ToogleSelected(SelIdx);
          DrawSelected(NamesStartY, SelIdx, SelIdx);
          ShowSelected(ScreenWidth - 30, NamesStartY + PageNames div NameColumns + 1);
          DefaultPrompt
        end;
        'N':
        begin
          ClearSelected;
          DrawPage(PageNum, NamesStartY, SelIdx);
          ShowSelected(ScreenWidth - 30, NamesStartY + PageNames div NameColumns + 1);
          DefaultPrompt
        end;
        'A':
        begin
          SelectAll;
          DrawPage(PageNum, NamesStartY, SelIdx);
          ShowSelected(ScreenWidth - 30, NamesStartY + PageNames div NameColumns + 1);
          DefaultPrompt
        end;
        'I':
        begin
          ReqestFileImport(SelIdx);
          DefaultPrompt
        end ;
        'B':
        begin
          ImportSelected;
          DefaultPrompt
        end
      end
    end
  end;
  CrtExit
end.