;Config program for com port
;
;Display port addresses
;
comCfg	equ	20h		;com port 1 config port
;
	org	100h
ENTRY:	lxi	h,0		;save old stack pointer
	dad	sp		;HL = SP
	shld	OLDSTK		;save stack to memory
	lxi	sp,NEWSTK	;load new stack address
;
	mvi	a,jmp		;get jump opcode
	sta	CONOUT		;save jump address
	sta	CONSTA		;save jump address
	lhld	01h		;get CPM warm boot address
	lxi	b,3		;offset from WBOOT to CONST
	dad	b		;address to jump to for const
	shld	CONSTA+1	;save address
	lxi	b,6		;offset from CONST to CONOUT
	dad	b		;address to jump to for conout
	shld	CONOUT+1	;save console staus address
	jmp	START
;
;local variables
;
CONOUT:	ds	3	;address of console out function
CONSTA:	ds	3	;address of console input status function
OLDSTK:	dw	0100h	;value of stack pointer on entry
TOPSTK: ds	0100h	;location of new stack
NEWSTK	set	$-1
;
;
OUTCHR:	;DIRECT Console Output Call Here
	push	b		;save bc
	push	psw		;save character
	mov	c,a
	call	CONOUT
	pop	psw		;restore character
	pop	b		;restore bc
	ret
;
;
PRNEOL:	;output a CR LF to the console
	push	psw		;Save A
	mvi	a,0Dh		;C/R time
	call	OUTCHR
	mvi	a,0Ah		;LF time
	call	OUTCHR
	pop	psw		;restore A
	ret
;
;
PRNSP:	;output a space to the console
	push	psw		;Save A
	mvi	a,20h
	call	OUTCHR
	pop	psw		;restore A
	ret
;
;
PRNPLS:	;output a space to the console
	push	psw		;Save A
	mvi	a,'+'
	call	OUTCHR
	pop	psw		;restore A
	ret
;
;
PRNEQ:	;output a space to the console
	push	psw		;Save A
	mvi	a,'='
	call	OUTCHR
	pop	psw		;restore A
	ret
;
;
PRN16:	;print the 16 bit value in HL;
	push	h		;Save address
	mov	a,h
	call	PRN8		;Its nybble time
	mov	a,l
	call	PRN8		;Same with cr/lf
	pop	h		;Restore address
	ret
;
;
PRN8:	;print the 8 bit value in A
	push	psw		;Save A
	push	psw		;Save A
	rrc			;Shift nybble
	rrc
	rrc
	rrc
	call	PRN4		;Nybble out 1
	pop	psw		;Restore A
	call	PRN4		;Nybble out 2
	pop	psw		;Restore A
	ret
;
;
PRN4:	;print the nibble as a hex digit
	ani	0fh		;Strip high nibble
	cpi	0ah		;Divide alpha v numeric
	jm	ISNUM		;If numeric
	adi	07h		;Add alpha offset
ISNUM:	adi	30h		;Add numeric offset
	call	OUTCHR
	ret
;
;
PRNSTR:	;output the string at BC
	push	psw		;Save A
	push	b		;save the bc register
NXTSTR:	ldax	b		;load char from memory
	ora	a		;set CPU Z flag base on char
	jz	FNDNUL		;we have a 0 byte so stop
	call	OUTCHR		;write character
	inx	b		;point to next char
	JMP	NXTSTR
FNDNUL:	pop	b		;restore bc
	pop	psw		;restore A
	ret
;
;
;list of constant strings
;
HLPST1:	db 'Set UART paramaters on Mini80',0
HLPST2:	db 'Syntax: UART port, baud, parity, data bits, stop bits, handshake',0
HLPST3:	db '  port -- (1, 2, 3)',0
HLPST4:	db '  baud -- (300, 600, 1200, 2400, 3600, 4800, 7200, 9600, 14400)',0
HLPST5:	db '          (19200, 28800, 38400, 57600, 76800, 115200, 130200)',0

; Uart options help strings
HLPST6:	db '  parity -- (N, O, E)',0
HLPST7:	db '  data bits -- (7, 8)',0
HLPST8:	db '  stop bits -- (1, 2)',0
HLPST9:	db '  handshake -- (Y, N)',0
; Uart format and option labels
STR1:	db 'Baud Rate:',0
STR2:	db 'Data Format:',0
STR3:	db 'Stop Bits:',0
STR4:	db 'Hardware Handshake:',0
STRER:	db 'Invalid',0
STRER2:	db '         ',0
STRERS:	db '  setting format!',0
; Uart boolean value labels
STRON:	db 'On',0
STROFF:	db 'Off',0
; Uart supported baudrate strings
BS300:	db '300',0
BS600:	db '600',0
BS1200:	db '1200',0
BS2400:	db '2400',0
BS3600: db '3600',0
BS4800:	db '4800',0
BS7200: db '7200',0
BS9600:	db '9600',0
BS144:	db '14400',0
BS192:	db '19200',0
BS288:	db '28800',0
BS384:	db '38400',0
BS576:	db '57600',0
BS768:	db '76800',0
BS1152:	db '115200',0
BS1302: db '130200',0
; Uart baud rate string lookup tabel
BRTAB:	dw	BS300
	dw	BS600
	dw	BS1200
	dw	BS2400
	dw	BS3600
	dw	BS4800
	dw	BS7200
	dw	BS9600
	dw	BS144
	dw	BS192
	dw	BS288
	dw	BS384
	dw	BS576
	dw	BS768
	dw	BS1152
	dw	BS1302
; Uart data format strings
FS7N:	db '7 bits no parity',0
FS7E:	db '7 bits even parity',0
FS7O:	db '7 bits odd parity',0
FS8N:	db '8 bits no parity',0
HSHD:	db '8 bits no parity',0
	db 0
;
; Calculate the address of the baud rate string
; on entry A = baud index (0..15)
; on exit BC = address of baud rate string
BRADR:	push 	psw
	push	h	; save HL register to stack
	ani	0Fh	;mask off the baud
	; register a = baud rate index
	add	a	; mult by 2
	lxi	h, BRTAB ; Load address of baud rate string table
	add	l
	mov	l, a
	mvi	a, 0
	adc	h
	mov	h, a
	; HL = address of baud rate string table entry
	mov	c, m
	inx	h
	mov	b, m
	; BC = address of baud rate string
	pop	h
	pop	psw
	ret
;
; output the baud rate from the config in a
PRNBUD:	push	psw	;save a
	push	b	;save bc register
	ani	0Fh	;mask off the baud
	; register a = baud rate index
	call	BRADR
	; BC = address of baud rate string
	call	PRNSTR
	; Restore stack and exit
	pop b
	pop psw
	ret
;
;
PRFMT:	push	psw
	rrc
	rrc
	rrc
	rrc
	ani	03h	;mask off the format
	jnz	PRFMT2
	lxi	b,FS7N
	call	PRNSTR
	JMP	PRFMT1
PRFMT2:	dcr	a	;try next
	jnz	PRFMT3
	lxi	b,FS7E
	call	PRNSTR
	JMP	PRFMT1
PRFMT3:	dcr	a	;try next
	jnz	PRFMT4
	lxi	b,FS7O
	call	PRNSTR
	JMP	PRFMT1
PRFMT4:	lxi	b,FS8N
	call	PRNSTR
PRFMT1: pop psw
	ret
;
;
PRSTB:	push	psw
	ani	40h
	jnz	PRSTB2
	mvi	a,'1'
	jmp	PRSTB1
PRSTB2: mvi	a,'2'
PRSTB1: call	OUTCHR
	pop psw
	ret
;
;
PRHHS:	push	psw
	push	b
	ani	80h
	jnz	PRHHS2
	lxi	b,STROFF;
	call	PRNSTR
	jmp	PRHHS1
PRHHS2: lxi	b,STRON;
	call	PRNSTR
PRHHS1: pop	b
	pop	psw
	ret
;
;
	;pack the command tail removing commas and extra blanks
PKARG:	push	b
	push	d
	push	psw
	push	h
	lxi	h,1	;space count = 1 reg L, CHar count = 0 (reg h) 
	lxi	b,81h
	lxi	d,81h
PKARG2:	ldax	b	;read next character in string
	inx	b	;point to next character
	ora	a	;see if it is zero
	jz	PKARG1	;if is a 0 byte then quit
	CPI	','	;not a null so see if white space
	jz	PKARG3
	CPI	' '
	jz	PKARG3	;if not a space just copy
	push	psw	;save the character
	mov	a,l
	ora	a
	jz	PKARG5	;no space required
	mov	a,h	;load character count to reg A
	ora	a	;set flags
	jz	PKARG5	;no space if first character
	mvi	a,20h	;convert to a space incase a comma
	stax	d	;save to string
	inx	d	;point to next write location
PKARG5:	pop	psw	;restore character
	stax	d	;not a space so just copy
	inx	d
	inr	h	;increase character count
	mvi	l,0	;clear space count
	jmp	PKARG2
	;we have a space see if we want it
PKARG3:	mov	a,l
	ora	a
	jnz	PKARG4	;no space required
	;we want the space
	inr	l	;indicate we have a space
PKARG4: jmp	PKARG2	;try next character
	;all done
PKARG1:	mvi	a,0	;save a null to end of string
	stax	d	;save to string
	pop	h
	pop	psw
	pop	d
	pop	b
	ret
;
;
ARGLN:	;returns the length of the comand tail in REG A
	push	b
	push	h
	lxi	h,0	;clear count in reg L
	lxi	b,81h	;point to command tail
ARGLN2:	ldax	b
	ora	a
	jz	ARGLN1
	inx	b
	inr	l
	jmp	ARGLN2	;not done yet
ARGLN1:	mov 	a,l
	pop	h
	pop	b
	ret
;
;
ARGCNT:	;returns the number of paramaters in comand tail in REG A
	push	b
	push	h
	lxi	h,100h	;clear param count in reg L, reg H is 1
	lxi	b,81h	;point to command tail
ARCNT2:	ldax	b
	ora	a
	jz	ARCNT1
	cpi	' '
	jnz	ARCNT3
	;we have a space
	inr	h	;indicate we have a space
	inx	b	;point to next character
	jmp	ARCNT2	;not done yet
	;we have a character
ARCNT3:	mov	a,h	;see space count > 0
	ora	a	;set flags
	jz	ARCNT4	;if A > 0 we have a new param
	inr	l	;increment the paramater count
	mvi	h,0	;clear space count
ARCNT4:	inx	b	;point to next character
	jmp	ARCNT2	;not done yet
ARCNT1:	mov 	a,l
	pop	h
	pop	b
	ret
;
;
PRNBYT:	;write reg A byte as a decimal number
	push	psw
	push	h
	push	b
	lxi	h,0
	mov	b,a
	mvi	a,07h	;get first three bits and save into l
	ana	b
	mov 	l,a
	mvi	a,08h
	ana	b
	jz	BD4	;bit 3 is not set so no add
	mvi	a,08h	;add in bit 3
	add	l	;
	daa		;decimal adjust result
	mov	l,a	;save result back to hl
BD4:	mvi	a,10h	;
	ana	b
	jz	BD5	;if bit 4 not set try bit 5
	mvi	a,16h
	add	l
	daa
	mov	l,a
BD5:	mvi	a,20h	;
	ana	b
	jz	BD6	;if bit 5 not set try bit 6
	mvi	a,32h
	add	l
	daa
	mov	l,a
BD6:	mvi	a,40h	;
	ana	b
	jz	BD7	;if bit 6 not set try bit 7
	mvi	a,64h
	add	l
	daa
	mov	l,a
	jnc	BD7
	inr	h
BD7:	mvi	a,80h	;
	ana	b
	jz	BDOUT	;not bit 7 so just output
	mvi	a,28h
	add	l
	jnc	BD7A
	inr	h
BD7A:	inr	h
BDOUT:	;register hl contains the 3 digit bcd number
	mvi	b,0	;set non zero flag to false
	mov	a,h	;read MS digit
	ani	0Fh	
	jz	BDOUT1
	adi	'0'
	call	OUTCHR
	inr	b
BDOUT1:	mov	a,l
	clc
	rrc
	rrc
	rrc
	rrc
	ani	0Fh
	jnz	BDOUT2
	;we have a zero see if prior digit is zero
	mov	c,a	;save digit
	mov	a,b	;test for non 0 count
	ora	a	;set the flags
	jz	BDOUT3	;last digit also zero so do not display
	mov	a,c	;restore last digit
BDOUT2:	adi	'0'
	call	OUTCHR
BDOUT3:	mov	a,l
	ani	0Fh
	adi	'0'
	call	OUTCHR
	pop	b
	pop	h
	pop	psw
	ret
;
;
PRNFMT:	;print the current com settings in reg A
	push	psw
	push	b
	call	PRNSP
	lxi	b,STR1;
	call	PRNSTR
	call	PRNSP
	call	PRNBUD
	call	PRNEOL
	call	PRNSP
	lxi	b,STR2;
	call	PRNSTR
	call	PRNSP
	call	PRFMT
	call	PRNEOL
	call	PRNSP
	lxi	b,STR3;
	call	PRNSTR
	call	PRNSP
	call	PRSTB
	call	PRNEOL
	call	PRNSP
	lxi	b,STR4;
	call	PRNSTR
	call	PRNSP
	call	PRHHS
	call	PRNEOL
	pop	b
	pop	psw
	ret
;
;
;parse the command looking for com port
;register C contains the port number
;if an error occured register A <> 0
PRPORT:	push	h
	push	d
	lxi	d,81h	;point to start of command
	ldax	d	;read port number (1..3)
	cpi	'1'	;
	jz	PRPRT1	;valid port number
	cpi	'2'	;
	jz	PRPRT2	;valid port number
	cpi	'3'	;
	jz	PRPRT3	;valid port number
	mvi	a,2
	jmp	PRPRTB	;bad port number
	;ok valid port number save to reg c
PRPRTB:	ora	a
	jnz	PRPRTE
	mvi	a,0FFh
	jmp	PRPRTE
PRPRT1: mvi	c,1
	jmp	PRPRTC
PRPRT2: mvi	c,2
	jmp	PRPRTC
PRPRT3: mvi	c,3
PRPRTC: inx	d	;make sure next char is a space or a null
	ldax	d
	cpi	20h
	jz	PRPRTF	;if was a space we are done
	cpi	00h
	jz	PRPRTF	;if was a null we are done
	mvi	a,2
	jmp	PRPRTB	;bad port number
PRPRTF:	xra	a	;clear error return code
PRPRTE:	pop	d
	pop	h
	ret
;
;
;see if sub string (DE) is at the start of string (BC) 
;both are null terminated
;register A is 0 if compare true
STRST:	push	h
	push	d
	push	b
STRSTN:	ldax	d	;get next sub string character
	cpi	0
	jz	STRSF	;at end of sub string so we are done
	mov	h,a	;save the last sub string character
	ldax	b	;get next search string character
	cpi	0
	jz	STRSNF	;at end of search string so we failed
	cmp	h	;see if they match
	jnz	STRSNF	;
	inx	d
	inx	b
	jmp	STRSTN	;try next character
STRSNF:	mvi	a,0FFh	;we failed report error and exit
STRSF:	pop	b
	pop	d
	pop	h
	ret
;
;
;parse the command looking for valid baud
;register A contains the baud rate 0..15
;if an error occured register A = FFh
PRBAUD:	push	h
	push	d
	push	b
	; start with first baud rate
	mvi	a, 0FFh	
	push	psw
PRBAD1:	pop	psw
	adi	1
	cpi	16
	jnc	PRBAD2		; tried all baud rates no match
	; register A = index of baud rate string to test
	push	psw		; save index
	call	BRADR		; BL = address of baud rate string
	mov	d, b
	mov	e, c		; DE = BC
	lxi	b,81h + 2	;point to start of baud rate
	call	STRST		;see if baud correct
	ora	a		;
	jnz	PRBAD1		;if we matched we are done
	; we have a match
	pop	psw
	jmp	PRBDON
	; indicate no match and return
PRBAD2:	mvi	a,0FFh		;indicate invalid baud index
PRBDON:	pop	b
	pop	d
	pop	h
	ret
;
;
;parse the command into com port settings
;register B contains the new port settings
;register C contains the port number
;if an error occured register A <> 0
PARSE:	push	h
	push	d
	lxi	b,0
	call	ARGLN	;get command tail length
	cpi	17	;valid params are 13..16 chars
	jnc	PRSER1
	cpi	13
	jc	PRSER1
	jmp	PARSE1
PRSER1:	mvi	a,1
	jmp	PRSERR
	;ok the length is valid get the port number
PARSE1:	call	PRPORT
	ora	a
	jz	PARSE2
	mvi	a,2
	jmp	PRSERR	;bad port number
	;get handshake from end of string
PARSE2:	call	ARGLN	;get command tail length
	dcr	a
	lxi	h,81h	;point to start of command
	mvi	d,0
	mov	e,a
	dad	d	;point to last char of params
	mov	d,h	;copy hl to de
	mov	e,l	;copy hl to de
	ldax	d	;read stop bits (1..2)
	cpi	'Y'	;
	jz	PRSHSY	;valid handshake setting
	cpi	'N'	;
	jz	PRSHSN	;valid handshake setting
	mvi	a,7
	jmp	PRSERR	;bad handshake setting
PRSHSY:	mvi	a,80h
	jmp	PARSE5
PRSHSN: mvi	a,00h
PARSE5:	ora	b
	mov	b,a
	;get stop bits from end of string - 2
	call	ARGLN	;get command tail length
	dcr	a
	lxi	h,7Fh	;point to start of command - 2
	mvi	d,0
	mov	e,a
	dad	d	;point to last char -2 of params
	mov	d,h	;copy hl to de
	mov	e,l	;copy hl to de
	ldax	d	;read stop bits (1..2)
	cpi	'1'	;
	jz	PRSST1	;valid stop bit setting
	cpi	'2'	;
	jz	PRSST2	;valid stop bit setting
	mvi	a,6
	jmp	PRSERR	;bad stop bits
PRSST2:	mvi	a,40h	;set two stop bits
	jmp	PARSE6
PRSST1:	mvi	a,00h	;for one stop bit nothing to set
PARSE6:	ora	b
	mov	b,a	;save new settings
	;prior char should be a space
	dcx	d
	ldax	d
	cpi	20h
	mvi	a,4
	jnz	PRSERR
	;prior character should be data bits
	dcx	d	;point to prior character
	ldax	d	;load data bits paramater
	cpi	'7'	;
	jz	PRSD7	;valid data bit setting
	cpi	'8'	;
	jz	PRSD8	;valid data bit setting
	mvi	a,5
	jmp	PRSERR	;bad stop bits
PRSD8:	;we want 8 data bits parity must be N
	dcx	d	;skip space
	dcx	d	;point to parity
	ldax	d	;read parity paramater
	cpi	'N'	;
	mvi	a,4
	jnz	PRSERR	;invalid parity setting
	mvi	a,30h	;value for 8 bits no parity
	ora	b
	mov	b,a	;save new settings
	jmp	PRSBR	;parse baud rate
PRSD7:	;we want 7 data bits parity must be N or O or E
	dcx	d	;skip space
	dcx	d	;point to parity
	ldax	d	;read parity paramater
	cpi	'N'	;
	jz	PRS7N	;we want 7 data bits no parity	
	cpi	'E'	;
	jz	PRS7E	;we want 7 data bits even parity	
	cpi	'O'	;
	jz	PRS7O	;we want 7 data bits odd parity	
	mvi	a,4
	jnz	PRSERR	;invalid parity setting
PRS7E:	mvi	a,10h
	ora	b
	mov	b,a	;save new settings
	jmp	PRSBR
PRS7O:	mvi	a,20h
	ora	b
	mov	b,a	;save new settings
	jmp	PRSBR
PRS7N:	nop	;nothing to do
PRSBR:	;parse the baud rate
	call	PRBAUD
	cpi	0FFh	;check for error
	jnz	PARSE3
	mvi	a,3
	jmp	PRSERR	;invalid baud rate
PARSE3:	ora	b
	mov	b,a
PRSBOK:	xra	a	;set reg A = 0 indicate all OK
	jmp	PAREXT
PRSERR:	ora	a
	jnz	PAREXT
	mvi	a,0FFh
PAREXT:	pop	d
	pop	h
	ret
;
;
SHWHLP:	;show the help screen
	push	b
	push	psw
	lxi	b,HLPST1
	call	PRNSTR	;display help caption
	call	PRNEOL	;display a new line
	call	PRNEOL	;display a new line
	lxi	b,HLPST2
	call	PRNSTR	;display help line 1
	call	PRNEOL	;display a new line
	call	PRNEOL	;display a new line
	lxi	b,HLPST3
	call	PRNSTR	;display help line 2
	call	PRNEOL	;display a new line
	lxi	b,HLPST4
	call	PRNSTR	;display help line 3
	call	PRNEOL	;display a new line
	lxi	b,HLPST5
	call	PRNSTR	;display help line 3
	call	PRNEOL	;display a new line
	lxi	b,HLPST6
	call	PRNSTR	;display help line 3
	call	PRNEOL	;display a new line
	lxi	b,HLPST7
	call	PRNSTR	;display help line 3
	call	PRNEOL	;display a new line
	lxi	b,HLPST8
	call	PRNSTR	;display help line 3
	call	PRNEOL	;display a new line
	lxi	b,HLPST9
	call	PRNSTR	;display help line 3
	call	PRNEOL	;display a new line
	pop	psw
	pop	b
	ret
;
;
DSPERR:	;display the error code in register A
	push	b
	push	psw
	lxi	b,STRER
	call	PRNSTR	;display error message
	cpi	1
	jnz	DSPER2
	lxi	b,STRERS
	inx	b
	call	PRNSTR	;display error message
	jmp	DSPERD
DSPER2:	cpi	2
	jnz	DSPER3
	lxi	b,HLPST3	;display a port error
	inx	b
	call	PRNSTR	;display error message
	jmp	DSPERD
DSPER3:	cpi	3
	jnz	DSPER4
	lxi	b,HLPST4	;display a baud error
	inx	b
	call	PRNSTR	;display error message
	call	PRNEOL
	lxi	b,STRER2 ;print blanks equal to heading width
	inx	b
	call	PRNSTR	;display error message
	lxi	b,HLPST5	;display second line of baud error
	inx	b
	call	PRNSTR	;display error message
	jmp	DSPERD
DSPER4:	cpi	4
	jnz	DSPER5
	lxi	b,HLPST6	;display a parity error
	inx	b
	call	PRNSTR	;display error message
	jmp	DSPERD
DSPER5:	cpi	5
	jnz	DSPER6
	lxi	b,HLPST7	;display a data bit error
	inx	b
	call	PRNSTR	;display error message
	jmp	DSPERD
DSPER6:	cpi	6
	jnz	DSPER7
	lxi	b,HLPST8	;display a stop bit error
	inx	b
	call	PRNSTR	;display error message
	jmp	DSPERD
DSPER7:	cpi	7
	jnz	DSPERD
	lxi	b,HLPST9	;display a handshake error
	inx	b
	call	PRNSTR	;display error message
DSPERD:	pop	psw
	pop	b
	ret
;
;
START:	;begin main program
	call	PRNEOL	;start on a new line
	call	PKARG	;pack command tail to remove extra spaces
	call	ARGCNT	;count params in command tail
	ora	a
	jz	NOARGS
	cpi	1
	jz	ONEARG
	jmp	DOARGS
NOARGS:	call	SHWHLP
	JMP	EXIT
ONEARG: ;we have one paramater should be com port
	call	PRPORT	;parse com port id int reg C	 
	ora	a
	jnz	STRERR	;invalid com port if reg A <> 0
        mov	a,c	;get com port
	cpi	1
	jz	DSCOM1
	cpi	2
	jz	DSCOM2
	jmp	DSCOM3
DSCOM1: in	comCfg
	call	PRNFMT	;display current com port config
	call	PRNEOL	;display EOL characters
	jmp	EXIT
DSCOM2: in	ComCfg + 1
	call	PRNFMT	;display current com port config
	call	PRNEOL	;display EOL characters
	jmp	EXIT
	;we have a full com port config
DSCOM3: in	ComCfg + 2
	call	PRNFMT	;display current com port config
	call	PRNEOL	;display EOL characters
	jmp	EXIT
	;we have a full com port config
DOARGS:	call	PARSE
	ora	a
	jnz	STRERR
	mov	a,b
	call	PRNFMT	;display current com port config
	;set the config
        mov	a,c	;get com port
	cpi	1
	jz	SETCM1
	cpi	2
	jz	SETCM2
	jmp	SETCM3
SETCM1:	mov	a,b
	out	comCfg
	jmp	EXIT
SETCM2:	mov	a,b
	out	comCfg + 1
	jmp	EXIT
SETCM3:	mov	a,b
	out	comCfg + 2
	jmp	EXIT
STRERR:	call	PRNSP
	call	DSPERR
	call	PRNEOL	;display a new line
EXIT:	lhld	OLDSTK	;restore stack
	sphl
	ret		;return to CCP
	end.
